/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileAlterationListenerImpl
implements FileAlterationListener {
    public void onStart(FileAlterationObserver observer) {
        System.out.println("The FileListener has started on " + observer.getDirectory().getAbsolutePath());
    }

    public void onDirectoryCreate(File directory) {
        System.out.println(String.valueOf(directory.getAbsolutePath()) + " was created.");
    }

    public void onDirectoryChange(File directory) {
        System.out.println(String.valueOf(directory.getAbsolutePath()) + " wa modified");
    }

    public void onDirectoryDelete(File directory) {
        System.out.println(String.valueOf(directory.getAbsolutePath()) + " was deleted.");
    }

    public void onFileCreate(File file) {
        System.out.println(file.getAbsoluteFile() + " was created.");
        System.out.println("1. length: " + file.length());
        System.out.println("2. last modified: " + new Date(file.lastModified()));
        System.out.println("3. readable: " + file.canRead());
        System.out.println("4. writable: " + file.canWrite());
        UtilArquivoConfiguracao instanciaUtilArquivoConfiguraca = UtilArquivoConfiguracao.getInstancia();
        String dir = instanciaUtilArquivoConfiguraca.getValorPropertie("diretorio.retorno");
        File destino = new File(dir);
        try {
            FileUtils.moveToDirectory(file, destino, false);
        }
        catch (IOException e) {
            BBJPopupMensagem.exibirMensagemErro("N\u00e3o foi possivel copiar arquivo: " + file.getAbsolutePath() + " para " + destino.getAbsolutePath());
        }
    }

    public void onFileChange(File file) {
        System.out.println(file.getAbsoluteFile() + " was modified.");
        System.out.println("1. length: " + file.length());
        System.out.println("2. last modified: " + new Date(file.lastModified()));
        System.out.println("3. readable: " + file.canRead());
        System.out.println("4. writable: " + file.canWrite());
    }

    public void onFileDelete(File file) {
        System.out.println(file.getAbsoluteFile() + " was deleted.");
    }

    public void onStop(FileAlterationObserver observer) {
        System.out.println("The FileListener has stopped on " + observer.getDirectory().getAbsolutePath());
    }
}

