/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.FileAlterationListenerImpl;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileMonitorDemo {
    private static final String FOLDER = String.valueOf(System.getProperty("user.home")) + File.separator + "Downloads";
    private static final long pollingInterval = 30000L;

    public static void main(String[] args) throws Exception {
        File directory = new File(FOLDER);
        IOFileFilter directories = FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), HiddenFileFilter.VISIBLE);
        IOFileFilter filesRET = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter(".ret", IOCase.INSENSITIVE));
        IOFileFilter filter = FileFilterUtils.or(directories, filesRET);
        FileAlterationObserver fao = new FileAlterationObserver(directory, (FileFilter)filter);
        fao.addListener(new FileAlterationListenerImpl());
        FileAlterationMonitor monitor = new FileAlterationMonitor(30000L);
        monitor.addObserver(fao);
        monitor.start();
        System.out.println("Starting monitor (" + FOLDER + "). \"Press CTRL+C to stop\"");
    }
}

