/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.PluginInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class GerarXMLAplicativos
extends JPanel
implements ActionListener {
    private JPanel panelPasta = null;
    private JScrollPane panelMain = null;
    private JPanel panelBotoes = null;
    private JButton buttonLocalizar = null;
    private JButton buttonExecutar = null;
    private JTextField pasta = null;
    private JButton buttonSair = null;
    private JList listAplicativos = null;
    private DefaultListModel model;
    private JFileChooser chooser = null;
    private String path = null;

    public GerarXMLAplicativos() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelPasta(), "North");
        this.add((Component)this.getPanelMain(), "Center");
        this.add((Component)this.getPanelBotoes(), "South");
        this.initComponents();
    }

    private void initComponents() {
        this.getButtonExecutar().addActionListener(this);
        this.getButtonSair().addActionListener(this);
        this.getButtonLocalizar().addActionListener(this);
    }

    public static void main(String[] args) {
        JFrame fra = new JFrame("Configurar XML Aplicativos");
        fra.setLocationByPlatform(true);
        Dimension dim = new Dimension(600, 300);
        fra.setPreferredSize(dim);
        GerarXMLAplicativos gerapp = new GerarXMLAplicativos();
        fra.setContentPane(gerapp);
        gerapp.CarregaAplicativos();
        fra.setSize(dim);
        fra.setDefaultCloseOperation(2);
        fra.pack();
        fra.setVisible(true);
    }

    public void CarregaAplicativos() {
        this.setPath(this.getPasta().getText());
        File dir = new File(this.getPath());
        String[] children = dir.list();
        this.model = new DefaultListModel();
        int i = 0;
        while (children != null && i < children.length) {
            String filename = children[i];
            if (filename.indexOf(".jar") > 0) {
                this.model.addElement(filename);
            }
            ++i;
        }
        this.getListAplicativos().setModel(this.model);
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setLayout(new FlowLayout());
            this.panelBotoes.add(this.getButtonExecutar());
            this.panelBotoes.add(this.getButtonSair());
        }
        return this.panelBotoes;
    }

    public JScrollPane getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JScrollPane();
            this.panelMain.setOpaque(false);
            this.panelMain.setBorder(BorderFactory.createEmptyBorder(2, 10, 5, 20));
            this.panelMain.getViewport().setView(this.getListAplicativos());
            this.panelMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.panelMain.setBackground(Color.LIGHT_GRAY);
        }
        return this.panelMain;
    }

    public JList getListAplicativos() {
        if (this.listAplicativos == null) {
            this.listAplicativos = new JList();
            this.listAplicativos.setBackground(new Color(238, 238, 248));
        }
        return this.listAplicativos;
    }

    public JButton getButtonExecutar() {
        if (this.buttonExecutar == null) {
            this.buttonExecutar = new JButton("Executar");
            this.buttonExecutar.setPreferredSize(new Dimension(100, 22));
            this.buttonExecutar.setSize(new Dimension(100, 22));
        }
        return this.buttonExecutar;
    }

    public JButton getButtonSair() {
        if (this.buttonSair == null) {
            this.buttonSair = new JButton("Sair");
            this.buttonSair.setPreferredSize(new Dimension(100, 22));
            this.buttonSair.setSize(new Dimension(100, 22));
        }
        return this.buttonSair;
    }

    public JButton getButtonLocalizar() {
        if (this.buttonLocalizar == null) {
            this.buttonLocalizar = new JButton("Localizar");
            this.buttonLocalizar.setPreferredSize(new Dimension(100, 22));
            this.buttonLocalizar.setSize(new Dimension(100, 22));
        }
        return this.buttonLocalizar;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.getButtonExecutar()) {
            this.GerarArquivo();
        } else if (obj == this.getButtonLocalizar()) {
            this.getChooser().setVisible(true);
            int resp = this.getChooser().showOpenDialog(new JFrame());
            if (resp == 0) {
                String path = this.chooser.getSelectedFile().getPath();
                this.getPasta().setText(path);
                this.CarregaAplicativos();
            }
        } else if (obj == this.getButtonSair()) {
            System.exit(0);
        }
    }

    private void GerarArquivo() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(this.getPath()) + "/aplicativos.xml"));
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n");
            out.write("<aplicativos>\n");
            int cont = 0;
            while (cont < this.model.getSize()) {
                String s_file = String.valueOf(this.getPath()) + "/" + this.model.get(cont).toString();
                PluginInfo plginfo = this.GetFileInfo(s_file);
                out.write("  <aplicativo>\n");
                out.write("    <sigla>" + plginfo.getSigla() + "</sigla>\n");
                out.write("    <titulo>" + plginfo.getTitulo() + "</titulo>\n");
                out.write("    <versao>" + plginfo.getVersao() + "</versao>\n");
                out.write("    <versaodb>" + plginfo.getVersaodb() + "</versaodb>\n");
                out.write("    <datapacote>" + plginfo.getDatapacote() + "</datapacote>\n");
                out.write("    <nomejar>" + this.model.get(cont).toString() + "</nomejar>\n");
                out.write("    <tamanho>" + plginfo.getTamanho() + "</tamanho>\n");
                out.write("  </aplicativo>\n");
                ++cont;
            }
            out.write("</aplicativos>\n");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private PluginInfo GetFileInfo(String s_file) {
        PluginInfo plginfo = new PluginInfo();
        try {
            File fileJar = new File(s_file);
            plginfo.setTamanho(fileJar.length());
            JarFile jarFile = new JarFile(s_file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filename = entry.getName();
                System.out.println(filename);
                if (filename.indexOf(".points.") <= 0 && filename.indexOf("extension-points.") <= 0) continue;
                InputStream in = jarFile.getInputStream(jarFile.getEntry(filename));
                this.GravaArquivoTemporario(in);
                File filetmp = new File(String.valueOf(this.getPath()) + "/tmp.xml");
                SAXBuilder sax = new SAXBuilder();
                try {
                    Document doc = sax.build(filetmp);
                    Element tab = doc.getRootElement();
                    List lista = tab.getChildren("bean");
                    for (Element element : lista) {
                        String s_idbean = element.getAttributeValue("id");
                        if (s_idbean == null || !s_idbean.startsWith("plugin")) continue;
                        List props = element.getChildren("property");
                        for (Element elProp : props) {
                            String s_name = elProp.getAttributeValue("name");
                            String s_value = elProp.getAttributeValue("value");
                            if (s_name.equalsIgnoreCase("nome")) {
                                plginfo.setSigla(s_value);
                                continue;
                            }
                            if (s_name.equalsIgnoreCase("titulo")) {
                                plginfo.setTitulo(s_value);
                                continue;
                            }
                            if (s_name.equalsIgnoreCase("versao")) {
                                plginfo.setVersao(s_value);
                                continue;
                            }
                            if (s_name.equalsIgnoreCase("versaoDB")) {
                                plginfo.setVersaodb(s_value);
                                continue;
                            }
                            if (!s_name.equalsIgnoreCase("datapacote")) continue;
                            plginfo.setDatapacote(s_value);
                        }
                    }
                    filetmp.delete();
                }
                catch (JDOMException e) {
                    System.out.println("Ocorreu o erro: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Ocorreu o erro: " + s_file + " " + e.getMessage());
        }
        return plginfo;
    }

    private void GravaArquivoTemporario(InputStream in) {
        File filetmp = new File(String.valueOf(this.getPath()) + "/tmp.xml");
        if (filetmp.exists()) {
            filetmp.delete();
        }
        try {
            filetmp.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(filetmp));
            InputStreamReader lsInputReader = new InputStreamReader(in);
            BufferedReader lsBufferedReader = new BufferedReader(lsInputReader);
            String lsInput = null;
            while ((lsInput = lsBufferedReader.readLine()) != null) {
                if (lsInput.indexOf("<!DOCTYPE") != -1 || lsInput.indexOf("www.springframework.org") != -1) continue;
                out.write(lsInput);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public JTextField getPasta() {
        if (this.pasta == null) {
            this.pasta = new JTextField();
            this.pasta.setText("C:\\Program Files\\Apache Software Foundation\\Tomcat 7.0\\webapps\\gac\\aplicativos");
            this.pasta.setFont(new Font("Arial", 0, 14));
            this.pasta.setEditable(false);
        }
        return this.pasta;
    }

    public JPanel getPanelPasta() {
        if (this.panelPasta == null) {
            this.panelPasta = new JPanel();
            Dimension dim = new Dimension(0, 35);
            this.panelPasta.setPreferredSize(dim);
            this.panelPasta.setSize(dim);
            this.panelPasta.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.panelPasta.add((Component)new JLabel("Localiza\u00e7\u00e3o:"), gbc);
            gbc.gridx = 1;
            gbc.weightx = 2.0;
            gbc.fill = 1;
            this.panelPasta.add((Component)this.getPasta(), gbc);
            gbc.fill = 13;
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            this.panelPasta.add((Component)this.getButtonLocalizar(), gbc);
        }
        return this.panelPasta;
    }

    public JFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
            this.chooser.setCurrentDirectory(new File("\t"));
        }
        return this.chooser;
    }
}

