/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.Utilitarios;
import br.com.bb.plugins.gac.util.UtlrDatas_Dt;
import br.com.bb.plugins.gac.util.controller.servico.SecurityService;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;

public class Log {
    private String filename = null;
    private static Log log = null;
    private SecurityService seguranca;

    public static Log getInstance() {
        if (log == null) {
            log = new Log();
        }
        return log;
    }

    private Log() {
        String dirProg = System.getProperty("user.dir");
        UtlrDatas_Dt dt = new UtlrDatas_Dt();
        String dia = dt.getDiaAsString();
        this.filename = String.valueOf(dirProg) + System.getProperty("file.separator") + "BBGACLog" + dia + ".txt";
    }

    private void writeLog(Object msg, boolean exit) {
        Vector<String> mess = null;
        if (msg instanceof Vector) {
            mess = (Vector<String>)msg;
        } else if (msg instanceof Exception || msg instanceof Throwable) {
            ((Throwable)msg).printStackTrace();
            StackTraceElement[] st = msg instanceof Exception ? ((Exception)msg).getStackTrace() : ((Throwable)msg).getStackTrace();
            mess = new Vector<String>();
            int i = 0;
            while (i < st.length) {
                mess.add(st[i].toString());
                ++i;
            }
        }
        UtlrDatas_Dt dt = new UtlrDatas_Dt();
        String data = Utilitarios.adjustStrLen(dt.getDataAsTimestamp().toString(), 23);
        String w = String.valueOf(data.substring(8, 10)) + "-" + data.substring(5, 7) + "-" + data.substring(0, 4) + "     " + data.substring(10);
        String line = ">>>>> " + Utilitarios.adjustStrLen(this.getUsuarioAtual(), 30) + w + "\n";
        this.appendToFile(new String[]{line});
        int i = 0;
        while (i < mess.size()) {
            this.appendToFile(new String[]{(String)mess.elementAt(i)});
            ++i;
        }
        String s = "\n==================================================================================\n";
        this.appendToFile(new String[]{s});
        if (exit) {
            BBJPopupMensagem.exibirMensagemErro(this.getMsg());
            System.exit(0);
        }
    }

    private String getUsuarioAtual() {
        return this.seguranca != null && this.seguranca.getUsuarioAtual() != null ? this.seguranca.getUsuarioAtual().getTextoNome() : "";
    }

    private String getMsg() {
        String msg = "Aten\u00e7\u00e3o!!!\nOcorreu um erro grave ao executar este procedimento.\nLog : " + this.filename + "\n>>> Reinicie o Sistema.";
        return msg;
    }

    public void logMsg(Exception e) {
        this.writeLog(e, false);
    }

    public void logMsg(Throwable e) {
        this.writeLog(e, false);
    }

    public void logInfo(String[] info) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < info.length) {
            v.add(info[i]);
            ++i;
        }
        this.writeLog(v, false);
    }

    public void logInfo(String info) {
        Vector<String> v = new Vector<String>();
        v.add(info);
        this.writeLog(v, false);
    }

    public void logMsgNoExit(Throwable e) {
        this.writeLog(e, false);
    }

    public void logMsgNoExit(Exception e) {
        this.writeLog(e, false);
    }

    public void appendToFile(String[] lines) {
        try {
            File f = new File(this.filename);
            if (!f.exists()) {
                f.createNewFile();
            }
            RandomAccessFile fileIn = new RandomAccessFile(this.filename, "rw");
            fileIn.seek(fileIn.length());
            int i = 0;
            while (i < lines.length) {
                fileIn.writeBytes(String.valueOf(lines[i]) + "\n");
                ++i;
            }
            fileIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSeguranca(SecurityService service) {
        this.seguranca = service;
    }
}

