/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.business.CampoRelacionamentoBO;
import br.com.bb.plugins.gac.negocio.business.CampoTabelaBO;
import br.com.bb.plugins.gac.negocio.business.IndiceTabelaBO;
import br.com.bb.plugins.gac.negocio.business.RegistroTabelaBasicaBO;
import br.com.bb.plugins.gac.negocio.business.RelacionamentoTabelaBO;
import br.com.bb.plugins.gac.negocio.business.TabelaBO;
import br.com.bb.plugins.gac.util.PluginInfo;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.ZipUtils;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicoInfo {
    private static final ServicoInfo servicoInfo = new ServicoInfo();
    private String path = null;

    public static ServicoInfo getInstance() {
        return servicoInfo;
    }

    public PluginInfo GetFileInfo(String s_file) throws IOException, JDOMException {
        PluginInfo plginfo = null;
        File fileJar = new File(s_file);
        if (!fileJar.exists()) {
            return plginfo;
        }
        plginfo = new PluginInfo();
        plginfo.setTamanho(fileJar.length());
        JarFile jarFile = new JarFile(s_file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String filename = entry.getName();
            if (filename.indexOf(".points.") <= 0) continue;
            InputStream in = jarFile.getInputStream(jarFile.getEntry(filename));
            this.GravaArquivoTemporario(in);
            this.setDadosPlugin(plginfo);
            break;
        }
        return plginfo;
    }

    private void setDadosPlugin(PluginInfo plginfo) throws JDOMException, IOException {
        File filetmp = new File(String.valueOf(this.getPath()) + "/tmp.xml");
        SAXBuilder sax = new SAXBuilder();
        Document doc = sax.build(filetmp);
        Element tab = doc.getRootElement();
        List lista = tab.getChildren("bean");
        for (Element element : lista) {
            String s_idbean = element.getAttributeValue("id");
            if (s_idbean == null || !s_idbean.startsWith("plugin")) continue;
            List props = element.getChildren("property");
            for (Element elProp : props) {
                String s_name = elProp.getAttributeValue("name");
                String s_value = elProp.getAttributeValue("value");
                if (s_name.equalsIgnoreCase("nome")) {
                    plginfo.setSigla(s_value);
                    continue;
                }
                if (s_name.equalsIgnoreCase("titulo")) {
                    plginfo.setTitulo(s_value);
                    continue;
                }
                if (s_name.equalsIgnoreCase("versao")) {
                    plginfo.setVersao(UtilString.completarADireita(UtilString.removerCaracteres(s_value), "0", 5));
                    continue;
                }
                if (s_name.equalsIgnoreCase("versaoDB")) {
                    plginfo.setVersaodb(UtilString.completarADireita(s_value, "0", 5));
                    continue;
                }
                if (s_name.equalsIgnoreCase("datapacote")) {
                    plginfo.setDatapacote(s_value);
                    continue;
                }
                if (!s_name.equalsIgnoreCase("tiposegmento")) continue;
                plginfo.setTipoSegmento(Util.parseInt(s_value));
            }
        }
        filetmp.delete();
    }

    public Map<String, TabelaBO> getXMLEstruturaBDGAC() throws IOException, JDOMException, BBException {
        InputStream inputStream = UtilArquivo.getInputStream("recursos/tabelas_gac.xml");
        return this.getXMLEstruturaBD(inputStream, "GAC", "", null);
    }

    public Map<String, TabelaBO> getXMLEstruturaBD(String nomeArquivoJAR, String nomeArquivoXML, String nomeModulo, Map<String, TabelaBO> tabelasGAC) throws IOException, JDOMException, BBException {
        InputStream inputStream = this.getInputXML(nomeArquivoJAR, nomeArquivoXML);
        return this.getXMLEstruturaBD(inputStream, nomeModulo, nomeArquivoJAR, tabelasGAC);
    }

    public Map<String, TabelaBO> getXMLEstruturaBD(InputStream inputStream, String nomeModulo, String nomeArquivoJAR, Map<String, TabelaBO> tabelasGAC) throws IOException, JDOMException, BBException {
        LinkedHashMap<String, TabelaBO> tabelasXML = new LinkedHashMap<String, TabelaBO>();
        if (inputStream != null) {
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build(inputStream);
            Element tabs = doc.getRootElement();
            TabelaBO tabelaBO = null;
            CampoTabelaBO campoTabelaBO = null;
            IndiceTabelaBO indiceTabelaBO = null;
            RelacionamentoTabelaBO relacionamentoTabelaBO = null;
            List tabelas = tabs.getChildren("tabela");
            for (Element element : tabelas) {
                tabelaBO = new TabelaBO(element.getAttributeValue("nome"));
                tabelaBO.setVersao(element.getAttributeValue("versao"));
                tabelaBO.setBasica(element.getAttributeValue("basica"));
                tabelaBO.setSobreescrever(element.getAttributeValue("sobreescrever"));
                List campos = element.getChildren("campo");
                for (Element c : campos) {
                    campoTabelaBO = new CampoTabelaBO(c.getAttributeValue("nome"));
                    campoTabelaBO.setTipoCampo(c.getAttributeValue("tipo"));
                    campoTabelaBO.setTamanho(Integer.parseInt(c.getAttributeValue("tamanho")));
                    campoTabelaBO.setPermiteNulo(c.getAttributeValue("permitenulo").equalsIgnoreCase("S"));
                    campoTabelaBO.setSequencial(Integer.parseInt(c.getAttributeValue("sequencial")));
                    tabelaBO.getCampos().put(campoTabelaBO.getNomeCampo(), campoTabelaBO);
                }
                Element chave = element.getChild("chaveprimaria");
                if (chave != null) {
                    IndiceTabelaBO chavePri = new IndiceTabelaBO(chave.getAttributeValue("nome"));
                    List camposChave = chave.getChildren("campo");
                    for (Element el : camposChave) {
                        CampoTabelaBO campoTabelaBOPK = new CampoTabelaBO(el.getAttributeValue("nome"));
                        campoTabelaBOPK.setSequencial(Util.parseInt(el.getAttributeValue("sequencial")));
                        if (tabelaBO.getCampos().get(campoTabelaBOPK.getNomeCampo()) != null) {
                            tabelaBO.getCampos().get(campoTabelaBOPK.getNomeCampo()).setChave(true);
                            campoTabelaBOPK.setTipoCampo(tabelaBO.getCampos().get(campoTabelaBOPK.getNomeCampo()).getTipoCampo());
                        }
                        chavePri.getCampos().put(campoTabelaBOPK.getNomeCampo(), campoTabelaBOPK);
                    }
                    tabelaBO.setChavePrimaria(chavePri);
                }
                List indices = element.getChildren("indice");
                for (Element i : indices) {
                    indiceTabelaBO = new IndiceTabelaBO(i.getAttributeValue("nome"));
                    List camposind = i.getChildren("campo");
                    for (Element ci : camposind) {
                        indiceTabelaBO.getCampos().put(tabelaBO.getCampos().get(ci.getAttributeValue("nome")).getNomeCampo(), tabelaBO.getCampos().get(ci.getAttributeValue("nome")));
                    }
                    tabelaBO.getIndices().put(indiceTabelaBO.getNome(), indiceTabelaBO);
                }
                tabelasXML.put(tabelaBO.getNome(), tabelaBO);
                if (!"S".equalsIgnoreCase(tabelaBO.getBasica())) continue;
                this.carregarDadosBasicos(tabelaBO, nomeModulo, nomeArquivoJAR);
            }
            for (Element element : tabelas) {
                TabelaBO tabe = (TabelaBO)tabelasXML.get(element.getAttributeValue("nome"));
                List rels = element.getChildren("relacionamento");
                for (Element el : rels) {
                    relacionamentoTabelaBO = new RelacionamentoTabelaBO(el.getAttributeValue("nome"));
                    relacionamentoTabelaBO.setTabelaDestino(tabe);
                    String nomeTabelaOrigem = el.getAttributeValue("nometabelaorigem");
                    relacionamentoTabelaBO.setTabelaOrigem((TabelaBO)tabelasXML.get(nomeTabelaOrigem));
                    if (relacionamentoTabelaBO.getTabelaOrigem() == null && !"GAC".equalsIgnoreCase(nomeModulo)) {
                        relacionamentoTabelaBO.setTabelaOrigem(tabelasGAC.get(nomeTabelaOrigem));
                    }
                    List l = el.getChildren("campo");
                    for (Element cr : l) {
                        CampoTabelaBO campoo = relacionamentoTabelaBO.getTabelaOrigem().getCampos().get(cr.getAttributeValue("origem"));
                        CampoTabelaBO campod = tabe.getCampos().get(cr.getAttributeValue("destino"));
                        Integer i = new Integer(cr.getAttributeValue("sequencial"));
                        CampoRelacionamentoBO camporelbo = new CampoRelacionamentoBO(campoo, campod);
                        relacionamentoTabelaBO.getCampos().put("" + i, camporelbo);
                    }
                    tabe.getRelacionamentos().put(relacionamentoTabelaBO.getNome(), relacionamentoTabelaBO);
                }
            }
        }
        return tabelasXML;
    }

    private void carregarDadosBasicos(TabelaBO tabelaBO, String nomeModulo, String nomeArquivoJAR) throws BBException, JDOMException, IOException {
        InputStream inputStream = this.getInputXMLTabelaBasica(tabelaBO.getNome(), nomeModulo, nomeArquivoJAR);
        if (inputStream != null) {
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build(inputStream);
            Element tab = doc.getRootElement();
            List lista = tab.getChildren(tabelaBO.getNome().toLowerCase());
            for (Element element : lista) {
                List campos = element.getAttributes();
                RegistroTabelaBasicaBO registroTabelaBasicaBO = new RegistroTabelaBasicaBO();
                for (Attribute att : campos) {
                    CampoTabelaBO campoTabelaBO = new CampoTabelaBO(att.getName());
                    campoTabelaBO.setValor(att.getValue());
                    registroTabelaBasicaBO.getCamposTabela().add(campoTabelaBO);
                }
                tabelaBO.getRegistroTabelaBasica().add(registroTabelaBasicaBO);
            }
        }
    }

    private InputStream getInputXMLTabelaBasica(String nomeTabela, String nomeModulo, String nomeArquivoJAR) throws IOException {
        InputStream inputStream = null;
        inputStream = "GAC".equalsIgnoreCase(nomeModulo) ? UtilArquivo.getInputStream("recursos/tab_" + nomeTabela.toLowerCase() + ".xml") : this.getInputXML(nomeArquivoJAR, "tab_" + nomeTabela.toLowerCase() + ".xml");
        return inputStream;
    }

    public String getVersaoXMLBD(String nomeArquivoJAR, String nomeArquivoXML) throws IOException, JDOMException {
        InputStream inputStream = this.getInputXML(nomeArquivoJAR, nomeArquivoXML);
        if (inputStream != null) {
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build(inputStream);
            Element tabs = doc.getRootElement();
            String versaoBDXML = tabs.getChild("versao").getAttributeValue("vrs");
            return versaoBDXML;
        }
        return null;
    }

    private InputStream getInputXML(String nomeArquivoJAR, String nomeArquivoXML) throws IOException {
        File file = new File(nomeArquivoJAR);
        if (!file.exists()) {
            return null;
        }
        JarFile jarFile = new JarFile(nomeArquivoJAR);
        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("recursos/" + nomeArquivoXML));
        return inputStream;
    }

    public String getVersaoXMLBDGAC(String dirProg) throws JDOMException, IOException {
        InputStream inputStream = UtilArquivo.getInputStream("recursos/tabelas_gac.xml");
        if (inputStream != null) {
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build(inputStream);
            Element tabs = doc.getRootElement();
            String versaoBDXML = tabs.getChild("versao").getAttributeValue("vrs");
            return versaoBDXML;
        }
        return "";
    }

    private void GravaArquivoTemporario(InputStream in) throws IOException {
        File filetmp = new File(String.valueOf(this.getPath()) + "/tmp.xml");
        if (filetmp.exists()) {
            filetmp.delete();
        }
        filetmp.createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(filetmp));
        InputStreamReader lsInputReader = new InputStreamReader(in);
        BufferedReader lsBufferedReader = new BufferedReader(lsInputReader);
        String lsInput = null;
        while ((lsInput = lsBufferedReader.readLine()) != null) {
            if (lsInput.indexOf("<!DOCTYPE") != -1 || lsInput.indexOf("www.springframework.org") != -1) continue;
            out.write(lsInput);
        }
        out.close();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PluginInfo GetFileInfoGAC() throws JDOMException, IOException {
        PluginInfo pluginInfo = new PluginInfo();
        InputStream inputStream = UtilArquivo.getInputStream("META-INF/services/extension-points.xml");
        this.GravaArquivoTemporario(inputStream);
        this.setDadosPlugin(pluginInfo);
        if (pluginInfo.getTipoSegmento() == 0) {
            pluginInfo.setTipoSegmento(1);
        }
        System.out.println("Vers\u00e3o GAC Instalado: " + pluginInfo.getVersao() + " Banco: " + pluginInfo.getVersaodb());
        return pluginInfo;
    }

    public PluginInfo getFileInfoGACParaAtualizacao() throws JDOMException, IOException, BBException {
        PluginInfo pluginInfo = new PluginInfo();
        byte[] bbgacjarBytes = ZipUtils.descompactaBYTE(String.valueOf(this.getPath()) + File.separator + "bbgac.zip", "bbgac.jar");
        byte[] extensionPoints = ZipUtils.descompacta(bbgacjarBytes, "META-INF/services/extension-points.xml");
        ByteArrayInputStream bais = new ByteArrayInputStream(extensionPoints);
        this.GravaArquivoTemporario(new BufferedInputStream(bais));
        this.setDadosPlugin(pluginInfo);
        if (pluginInfo.getTipoSegmento() == 0) {
            pluginInfo.setTipoSegmento(1);
        }
        return pluginInfo;
    }
}

