/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.FormatadorNumero;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJText;
import br.com.bb.plugins.gac.util.view.BBJFormPopup;
import br.com.politec.infra.util.UtilLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String verificaAgencia(String agencia) throws Exception {
        String dvagf;
        String valor = null;
        Object titulo = null;
        Object mensagem = null;
        String agcnt = null;
        Object cc = null;
        Object cpfcnpj = null;
        String resultado = "";
        CalculaDigitoVerificador clsdv = new CalculaDigitoVerificador();
        valor = CalculaDigitoVerificador.tirarTracoPonto(agencia);
        if (valor.trim().length() == 0) {
            return null;
        }
        agcnt = clsdv.formatarPrefixoAgenciaSemDV((int)new Integer(valor));
        resultado = String.valueOf(agcnt);
        valor = CalculaDigitoVerificador.tirarTracoPonto(agcnt).substring(0, 4);
        String dvag = FormatadorNumero.formatarPrefixoAgencia((int)new Integer(valor)).substring(6);
        if (!dvag.equals(dvagf = clsdv.getDv())) {
            throw new Exception("Erro na Ag\u00eancia");
        }
        return resultado;
    }

    public static Vector getCampoEcores(String info) {
        if (info == null || info.length() == 0) {
            return null;
        }
        String campo = info.substring(0, info.indexOf("~"));
        int n = info.indexOf("[");
        String txt = info.substring(n + 3);
        int[] kores = new int[3];
        n = -1;
        StringTokenizer st = new StringTokenizer(txt, "=,]g,b");
        while (st.hasMoreTokens()) {
            kores[++n] = Integer.parseInt(st.nextToken());
        }
        Vector<Object> v = new Vector<Object>();
        v.add(campo);
        v.add(kores);
        return v;
    }

    public static Vector getCamposEcores(String[] info) {
        try {
            Vector<Vector> res = new Vector<Vector>();
            int i = 0;
            while (i < info.length) {
                res.add(Util.getCampoEcores(info[i]));
                ++i;
            }
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getEstado(String uf) {
        HashMap<String, String> estados = new HashMap<String, String>();
        estados.put("AC", "Acre");
        estados.put("AL", "Alagoas");
        estados.put("AM", "Amazonas");
        estados.put("AP", "Amap\u00e1");
        estados.put("BA", "Bahia");
        estados.put("CE", "Cear\u00e1");
        estados.put("DF", "Distrito Federal");
        estados.put("ES", "Esp\u00edrito Santo");
        estados.put("GO", "Goi\u00e1s");
        estados.put("MA", "Maranh\u00e3o");
        estados.put("MG", "Minas Gerais");
        estados.put("MS", "Mato Grosso do Sul");
        estados.put("MT", "Mato Grosso");
        estados.put("PA", "Par\u00e1");
        estados.put("PB", "Para\u00edba");
        estados.put("PE", "Pernambuco");
        estados.put("PI", "Piau\u00ed");
        estados.put("PR", "Paran\u00e1");
        estados.put("RJ", "Rio de Janeiro");
        estados.put("RN", "Rio Grande do Norte");
        estados.put("RO", "Rond\u00f4nia");
        estados.put("RR", "Roraima");
        estados.put("RS", "Rio Grande do Sul");
        estados.put("SC", "Santa Catarina");
        estados.put("SE", "Sergipe");
        estados.put("SP", "S\u00e3o Paulo");
        estados.put("TO", "Tocantins");
        return ((String)estados.get(uf)).toString();
    }

    public static int getColumnIndex(JTable tab, String colHeader) {
        int i = 0;
        while (i < tab.getColumnCount()) {
            String s = tab.getColumnName(i).trim();
            if (s.compareTo(colHeader) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int[] getRowsSelected(JTable tab, String colHdr) {
        int col = Util.getColumnIndex(tab, colHdr);
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < tab.getRowCount()) {
            if (tab.getValueAt(i, col).equals(new Boolean(true))) {
                temp.add("" + i);
            }
            ++i;
        }
        int[] rows = new int[temp.size()];
        int n = 0;
        while (n < temp.size()) {
            rows[n] = Integer.parseInt((String)temp.elementAt(n));
            ++n;
        }
        return rows;
    }

    public static double getSomaCol(JTable tab, String colName, int[] exceptRows) {
        double soma = 0.0;
        int colInx = Util.getColumnIndex(tab, colName);
        int i = 0;
        while (i < tab.getRowCount()) {
            block11: {
                block10: {
                    if (exceptRows == null) break block10;
                    boolean bad = false;
                    int n = 0;
                    while (n < exceptRows.length) {
                        if (i == exceptRows[n]) {
                            bad = true;
                            break;
                        }
                        ++n;
                    }
                    if (bad) break block11;
                }
                String s = tab.getValueAt(i, colInx).toString().trim();
                StringBuffer aux = new StringBuffer("");
                int n = 0;
                while (n < s.length()) {
                    if (s.charAt(n) != '.') {
                        if (s.charAt(n) == ',') {
                            aux.append(".");
                        } else {
                            aux.append(s.charAt(n));
                        }
                    }
                    ++n;
                }
                soma += Double.parseDouble(aux.toString());
            }
            ++i;
        }
        return soma;
    }

    public static String getSelectedColContent(JTable tab, String colName) {
        int colInx = Util.getColumnIndex(tab, colName);
        int row = tab.getSelectedRow();
        return tab.getValueAt(row, colInx).toString().trim();
    }

    public static boolean stringContainsChar(char ch, String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String checkNome(String nome, String permissoes, String cespPerm) {
        int i;
        char ch;
        String s = nome.trim();
        if (s.compareTo("") == 0) {
            return "Campo vazio";
        }
        if (permissoes.indexOf("L") >= 0 && ((ch = s.charAt(0)) < 'A' || ch > 'Z')) {
            return "Primeiro caracter n\u00e3o \u00e9 Letra";
        }
        if (nome.length() < 3) {
            return "M\u00ednimo \u00e9 de 3 caracteres";
        }
        if (permissoes.indexOf("N") >= 0) {
            i = 0;
            while (i < nome.length()) {
                if (nome.charAt(i) >= '0' && nome.charAt(i) <= '9') {
                    return "N\u00fameros n\u00e3o s\u00e3o permitidos";
                }
                ++i;
            }
        }
        if (!(permissoes.indexOf("X") < 0 || (ch = nome.charAt(0)) >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9')) {
            return "Primeiro caracter deve ser LETRA ou N\u00daMERO";
        }
        if (cespPerm != null) {
            i = 0;
            while (i < nome.length() - 1) {
                if (Util.stringContainsChar(nome.charAt(i), cespPerm) && Util.stringContainsChar(nome.charAt(i + 1), cespPerm)) {
                    return "N\u00e3o s\u00e3o permitidos Caracteres Especiais consecutivos";
                }
                ++i;
            }
            StringTokenizer st = new StringTokenizer(nome, " ");
            while (st.hasMoreTokens()) {
                s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                boolean ok = false;
                int n = 0;
                while (n < s.length()) {
                    if (!Util.stringContainsChar(s.charAt(n), cespPerm)) {
                        ok = true;
                    }
                    ++n;
                }
                if (ok) continue;
                return "Nome inv\u00e1lido";
            }
        }
        return "";
    }

    public static String checkNome(String nome, String permissoes, String cespPerm, int min, int max) {
        String s = Util.checkNome(nome, permissoes, cespPerm);
        if (s.compareTo("") != 0) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(nome, " ");
        if (st.countTokens() > 1) {
            if (min == max) {
                return "N\u00e3o \u00e9 permitido mais de um nome";
            }
            return "Quantidade de nomes permitidos: " + min + " - " + max;
        }
        return "";
    }

    public static String checkIdentificador(String id) {
        return Util.checkNome(id, "L", "-._", 1, 1);
    }

    public static int sendQuestionMsg(Component thiz, String msg) {
        Object[] options = new Object[]{"Sim", "N\u00e3o"};
        return JOptionPane.showOptionDialog(thiz, msg, "Confirme", 0, 3, null, options, options[0]);
    }

    public static String formatarData(java.util.Date d) throws Throwable {
        if (d == null) {
            return " ";
        }
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(d);
        int ano = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        String dataFormatada = String.valueOf(Util.strZero(String.valueOf(dia), 2)) + "/" + Util.strZero(String.valueOf(mes), 2) + "/" + Util.strZero(String.valueOf(ano), 4);
        return dataFormatada;
    }

    public static String formatarData(java.util.Date data, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(data);
    }

    public static String formataDecimal(String valor) {
        DecimalFormat df = new DecimalFormat("###,##0.00");
        double db = Double.parseDouble(valor);
        return df.format(db);
    }

    public static String formatarDecimal(long valor, int nroCasaDecimais) throws Throwable {
        StringBuffer textoB = new StringBuffer();
        boolean negativo = false;
        if (valor < 0L) {
            negativo = true;
            valor *= -1L;
        }
        String temp = String.valueOf(valor);
        temp = Util.tirarPontos(temp);
        textoB.append(temp);
        int i = temp.length();
        if (i <= nroCasaDecimais) {
            textoB.append(Util.strZero(temp, nroCasaDecimais - 1));
        }
        if (nroCasaDecimais > 0) {
            textoB.insert(textoB.length() - nroCasaDecimais, ',');
        }
        int k = i - nroCasaDecimais - 3;
        while (k > 0) {
            textoB.insert(k, '.');
            k -= 3;
        }
        if (negativo) {
            textoB.insert(0, "-");
        }
        return textoB.toString();
    }

    public static String strZero(String valor, int comprimento) throws Throwable {
        String retorno = "0";
        if (valor == null) {
            valor = "";
        }
        if ((valor = valor.trim()).length() > comprimento) {
            throw new Throwable("O valor " + valor + " tem mais de " + comprimento + " d\u00edgitos. N\u00e3o foi poss\u00edvel alinhar.");
        }
        retorno = valor;
        int i = 0;
        while (i < comprimento - valor.length()) {
            retorno = "0" + retorno;
            ++i;
        }
        return retorno;
    }

    public static String tirarPontos(String valor) throws Throwable {
        if (valor == null) {
            valor = "";
        }
        int tam = valor.length();
        int i = 0;
        while (i < tam) {
            int posPonto = valor.indexOf(".");
            if (posPonto < 0) break;
            valor = String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, valor.length());
            ++i;
        }
        return valor;
    }

    public static String tirarPonto(String valor) {
        if (valor == null) {
            return "";
        }
        int i = valor.indexOf(".");
        if (i >= 0) {
            return String.valueOf(valor.substring(0, i)) + valor.substring(i + 1);
        }
        return valor;
    }

    public static String tirarVirgula(String valor) throws Throwable {
        if (valor == null) {
            valor = "";
        }
        int tam = valor.length();
        int i = 0;
        while (i < tam) {
            int posPonto = valor.indexOf(",");
            if (posPonto < 0) break;
            valor = String.valueOf(valor.substring(0, posPonto)) + valor.substring(posPonto + 1, valor.length());
            ++i;
        }
        return valor;
    }

    public static String trocarVirgulaPorPont(String valor) throws Throwable {
        return valor.replaceAll(",", ".");
    }

    public static String formatadaData(String aaaammdd) {
        if (aaaammdd == null || aaaammdd.trim().compareTo("") == 0) {
            return "";
        }
        String strYEAR = aaaammdd.substring(0, 4);
        int len = aaaammdd.length();
        String strMONTH = len == 10 ? aaaammdd.substring(5, 7) : aaaammdd.substring(4, 6);
        String strDAY = len == 10 ? aaaammdd.substring(8).trim() : aaaammdd.substring(6).trim();
        return String.valueOf(strDAY) + "/" + strMONTH + "/" + strYEAR;
    }

    public static String completaStringEsq(String str, int tamanho, char[] caracters) {
        StringBuffer strBuffer = new StringBuffer(str);
        boolean aspasRetiradas = false;
        if (strBuffer.toString().charAt(0) == '\'' && strBuffer.toString().charAt(strBuffer.toString().length() - 1) == '\'') {
            strBuffer.deleteCharAt(strBuffer.toString().length() - 1);
            strBuffer.deleteCharAt(0);
            aspasRetiradas = true;
        }
        while (strBuffer.length() < tamanho) {
            int len = 0;
            len = tamanho - strBuffer.length() >= caracters.length ? caracters.length : caracters.length - (tamanho - strBuffer.length());
            strBuffer.insert(0, caracters, 0, len);
        }
        if (aspasRetiradas) {
            strBuffer.insert(0, '\'');
            strBuffer.append('\'');
        }
        return strBuffer.toString();
    }

    public static void alinharColunasTabela(JTable tabela, DefaultTableModel model, int posicaoColuna, int tipoAlinhamento) {
        DefaultTableCellRenderer alinhamento = new DefaultTableCellRenderer();
        switch (tipoAlinhamento) {
            case 0: {
                alinhamento.setHorizontalAlignment(0);
                break;
            }
            case 1: {
                alinhamento.setHorizontalAlignment(2);
                break;
            }
            case 2: {
                alinhamento.setHorizontalAlignment(4);
            }
        }
        TableColumn tc = tabela.getColumnModel().getColumn(posicaoColuna);
        tc.setCellRenderer(alinhamento);
    }

    public static void putMap(HashMap map, String controle, int valor) {
        if (valor != 0) {
            map.put(controle, String.valueOf(valor));
            Util.marcarMap(map);
        } else {
            map.put(controle, null);
        }
    }

    public static void putMap(HashMap map, String strInicio, java.util.Date dtInicio, String strFim, java.util.Date dtFim) {
        if (dtInicio != null && dtFim != null) {
            Date dtIncial = new Date(dtInicio.getTime());
            Date dtFinal = new Date(dtFim.getTime());
            map.put(strInicio, dtIncial.toString());
            map.put(strFim, dtFinal.toString());
            Util.marcarMap(map);
        } else {
            map.put(strInicio, null);
            map.put(strFim, null);
        }
    }

    public static void putMap(HashMap map, BBJText txt, String controle) {
        if (!txt.getText().trim().equals("")) {
            map.put(controle, txt.getText());
            Util.marcarMap(map);
        } else {
            map.put(controle, null);
        }
    }

    public static void putMap(HashMap map, BBJComboBox cb, String controle) {
        if (cb.getSelectedIndex() != 0) {
            map.put(controle, cb.getObjetoSelecionado());
            Util.marcarMap(map);
        } else {
            map.put(controle, null);
        }
    }

    public static boolean isMapMarcado(HashMap map) {
        return map.containsKey("existeObjeto");
    }

    public static void marcarMap(HashMap map) {
        if (!map.containsKey("existeObjeto")) {
            map.put("existeObjeto", "");
        }
    }

    public static String converteDoubleAsString(double d) {
        return String.valueOf(d);
    }

    public static String converteIntAsString(int i) {
        return String.valueOf(i);
    }

    public static String completaZeros(int nroZeros, String str) {
        int preenchidos = str.trim().length();
        int faltam = nroZeros - preenchidos;
        String zeros = "";
        int i = 0;
        while (i < faltam) {
            zeros = String.valueOf(zeros) + "0";
            ++i;
        }
        return String.valueOf(zeros) + str;
    }

    public static String completaZeros(int nroZeros, int nro) {
        String str = String.valueOf(nro);
        int preenchidos = str.trim().length();
        int faltam = nroZeros - preenchidos;
        String zeros = "";
        int i = 0;
        while (i < faltam) {
            zeros = String.valueOf(zeros) + "0";
            ++i;
        }
        return String.valueOf(zeros) + str;
    }

    public static long getTimeInMillis() {
        Calendar cal = GregorianCalendar.getInstance();
        return cal.getTimeInMillis();
    }

    public static String[] getTokens(String line, String del) {
        String[] res = null;
        int i = -1;
        try {
            StringTokenizer st = new StringTokenizer(line, del);
            res = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                String txt = st.nextToken().trim();
                if (txt.equals("")) continue;
                res[++i] = txt;
            }
        }
        catch (Exception e) {
            UtilLog.getLog().debug(e);
        }
        return res;
    }

    public static long parseLong(String num) {
        long result = 0L;
        try {
            result = Long.parseLong(Util.tirarPontos(num));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static int parseInt(String num) {
        int result = 0;
        try {
            result = Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static long getDiasDaData(String data) {
        StringTokenizer stdt = new StringTokenizer(data, "/");
        int idia = stdt.hasMoreElements() ? Util.parseInt(stdt.nextToken()) : 0;
        int imes = stdt.hasMoreElements() ? Util.parseInt(stdt.nextToken()) : 0;
        int iano = stdt.hasMoreElements() ? Util.parseInt(stdt.nextToken()) : 0;
        return idia + imes * 30 + iano * 365;
    }

    public static void ImprimirRelatorio(String imagem) {
        Util.ImprimirRelatorio(imagem, null);
    }

    public static void ImprimirRelatorio(String imagem, Frame owner) {
        ViewRelatorio view = new ViewRelatorio(owner);
        ImageIcon img = new ImageIcon(view.getClass().getResource(imagem));
        JLabel label = new JLabel(img);
        JScrollPane scrp = new JScrollPane(label);
        scrp.setBackground(Color.WHITE);
        label.setBackground(Color.WHITE);
        view.add(scrp);
        view.setPreferredSize(new Dimension(800, 600));
        view.setSize(new Dimension(800, 600));
        view.doShow(null);
    }

    public static String substituirCaracteresEspeciais(String strVar) {
        int indice = 0;
        String strTexto = strVar.toUpperCase();
        String strValidos = "0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,-,., ,/";
        String strEspeciais = "\u00c1,\u00c0,\u00c3,\u00c2,\u00c4,\u00c9,\u00c8,\u00ca,\u00cb,\u00cd,\u00ce,\u00cf,\u00d3,\u00d2,\u00d4,\u00d5,\u00da,\u00d9,\u00dc,\u00c7,\u00d1,|";
        String strSubstitutos = "A,A,A,A,A,E,E,E,E,I,I,I,O,O,O,O,U,U,U,C,N,-";
        String strRetorno = "";
        int tamVar = strTexto.length();
        int i = 0;
        while (i < tamVar) {
            strRetorno = strValidos.indexOf(strTexto.substring(i, i + 1)) != -1 ? String.valueOf(strRetorno) + strTexto.substring(i, i + 1) : ((indice = strEspeciais.indexOf(strTexto.substring(i, i + 1))) == -1 ? String.valueOf(strRetorno) + " " : String.valueOf(strRetorno) + strSubstitutos.substring(indice, indice + 1));
            ++i;
        }
        return strRetorno;
    }

    public static void saveVectorOfStrAsFile(String fname, Vector s) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fname));
            String line = null;
            int i = 0;
            while (i < s.size()) {
                line = (String)s.elementAt(i);
                out.write(line);
                out.newLine();
                ++i;
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String formatarLinhaDigitavelCampo1(String texto) {
        return String.valueOf(texto.substring(0, 4)) + "." + texto.substring(5, 10);
    }

    public static String formatarLinhaDigitavelCampo2_3(String texto) {
        return String.valueOf(texto.substring(0, 4)) + "." + texto.substring(5, 11);
    }

    public static String formatarNossoNumero(String texto) {
        return String.valueOf(texto.substring(0, 2)) + "." + texto.substring(2, 5) + "." + texto.substring(5, 8) + "." + texto.substring(8, 11) + "-" + texto.substring(10, 11);
    }

    public static String imprimeArray(ArrayList<String> lista) {
        String retLista = "";
        for (String s : lista) {
            retLista = String.valueOf(retLista) + ", " + s.toString();
        }
        return retLista.substring(2);
    }

    public static String padR(String strOrigem, int comprimento, String caractereDePreenchimento) throws Throwable {
        String lRet = " ";
        int tamString = strOrigem.trim().length();
        if (tamString < comprimento) {
            lRet = strOrigem;
            int i = 0;
            while (i < comprimento - strOrigem.length()) {
                lRet = String.valueOf(caractereDePreenchimento) + lRet;
                ++i;
            }
        } else {
            lRet = strOrigem.substring(tamString - comprimento);
        }
        return lRet;
    }

    public static String formatarVersao(String versao) {
        if (versao.length() == 5) {
            String inicio = versao.substring(0, 1);
            String meio = versao.substring(1, 3);
            String fim = versao.substring(3);
            return String.valueOf(inicio) + "." + meio + "." + fim;
        }
        return versao;
    }

    public static void main(String[] args) {
        System.out.println(Util.formatarVersao("21015"));
    }

    private static class ViewRelatorio
    extends BBJFormPopup {
        public ViewRelatorio(Frame owner) throws HeadlessException {
            super(owner);
            this.getJpMain().remove(this.getJpTesteira());
            this.getBtnCancelar().setTexto("FECHAR");
            this.getBtnCancelar().setSize();
        }

        public void beforeShow(Map context) {
        }

        public void doClose(Map context) {
            this.setVisible(false);
        }

        public void doShow(Map context) {
            this.setVisible(true);
        }

        public int getTipoView() {
            return 0;
        }

        public void setTipoView(int tipoview) {
        }
    }
}

