/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class UtilAtualizarMapeamento
implements BeanFactoryPostProcessor {
    private String nomeDoPlugin;
    private String nomeDoMapeamento;
    private String nomeDaPropriedade;
    private Map mapa;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configuracao) throws BeansException {
        this.logAtualizandoMapeamento();
        this.verificarExistenciaDeMapeamento(configuracao);
        BeanDefinition mapeamento = this.getMapeamento(configuracao);
        MutablePropertyValues propriedades = this.getPropriedadesDoMapeamento(mapeamento);
        PropertyValue propriedade = this.getPropriedadeDoMapeamento(propriedades);
        Object valor = propriedade.getValue();
        if (UtilObjeto.isObjetoDoTipo(valor, Map.class)) {
            Map mapa = (Map)propriedade.getValue();
            mapa.putAll(this.getMapa());
        }
    }

    public String getNomeDoPlugin() {
        return this.nomeDoPlugin;
    }

    public void setNomeDoPlugin(String nomeDoPlugin) {
        this.nomeDoPlugin = nomeDoPlugin;
    }

    public String getNomeDoMapeamento() {
        return this.nomeDoMapeamento;
    }

    public void setNomeDoMapeamento(String nomeDoMapeamento) {
        this.nomeDoMapeamento = nomeDoMapeamento;
    }

    public String getNomeDaPropriedade() {
        return this.nomeDaPropriedade;
    }

    public void setNomeDaPropriedade(String nomeDaPropriedade) {
        this.nomeDaPropriedade = nomeDaPropriedade;
    }

    public Map getMapa() {
        return this.mapa;
    }

    public void setMapa(Map mapa) {
        this.mapa = mapa;
    }

    protected PropertyValue getPropriedadeDoMapeamento(MutablePropertyValues propriedades) {
        String propriedade = this.getNomeDaPropriedade();
        PropertyValue p = propriedades.getPropertyValue(this.nomeDaPropriedade);
        if (this.isVazio(propriedade) || !propriedades.contains(propriedade)) {
            StringBuffer sb = this.novoStringBuffer();
            sb.append("Propriedade '").append(propriedade).append("'");
            sb.append(" n\u00e3o encontrada para o mapeamento '");
            sb.append(this.getNomeDoMapeamento()).append("'.");
            throw new IllegalArgumentException(sb.toString());
        }
        return p;
    }

    protected MutablePropertyValues getPropriedadesDoMapeamento(BeanDefinition mapeamento) {
        return mapeamento.getPropertyValues();
    }

    protected BeanDefinition getMapeamento(ConfigurableListableBeanFactory configuracao) {
        return configuracao.getBeanDefinition(this.nomeDoMapeamento);
    }

    protected void verificarExistenciaDeMapeamento(ConfigurableListableBeanFactory configuracao) {
        String bean = this.getNomeDoMapeamento();
        if (this.isVazio(bean) || !configuracao.containsBeanDefinition(bean)) {
            StringBuffer sb = this.novoStringBuffer();
            sb.append("Mapeamento '").append(bean).append("'");
            sb.append(" n\u00e3o encontrado.");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    protected boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    protected void logAtualizandoMapeamento() {
        StringBuffer mensagem = this.novoStringBuffer();
        mensagem.append("Atualizando o mapeamento id='");
        mensagem.append(this.getNomeDoMapeamento()).append("' ");
        mensagem.append("com os mapeamentos do plugin '");
        mensagem.append(this.getNomeDoPlugin()).append("'");
        this.info(mensagem.toString());
    }

    protected void info(String mensagem) {
        System.out.println(mensagem);
    }

    protected StringBuffer novoStringBuffer() {
        return new StringBuffer();
    }
}

