/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.IdentificadorProprioConvenenteServicoFacade;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorProprioConvenenteServicoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabel;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;

public class UtilIdentificadorProprio {
    private static final String doisPontos = ":";
    private static UtilIdentificadorProprio instancia = new UtilIdentificadorProprio();

    public static UtilIdentificadorProprio getInstancia() {
        return instancia;
    }

    public String getNomeIdentificadorProprio() {
        try {
            IdentificadorTO identificadorTO = this.consultaIdentificadorProprio();
            return identificadorTO.getNomeIdentificador();
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public IdentificadorTO consultaIdentificadorProprioPor(ConvenenteTO convenenteTO, String servicoTO) {
        return this.getIdentificadorProprioConvenenteServicoFacade().consultaIdentificadorProprioPor(convenenteTO, servicoTO);
    }

    private IdentificadorTO consultaIdentificadorProprio() {
        ConvenenteTO convenente = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso().getConvenenteTO();
        String servico = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso().getServico();
        IdentificadorTO identificadorTO = this.getIdentificadorProprioConvenenteServicoFacade().consultaIdentificadorProprioPor(convenente, servico);
        return identificadorTO;
    }

    private IdentificadorProprioConvenenteServicoFacade getIdentificadorProprioConvenenteServicoFacade() {
        return FacadeFactory.getInstancia().novoIdentificadorProprioConvenenteServicoFacade();
    }

    public Integer getTamanhoIdentificadorProprio() {
        try {
            IdentificadorTO identificadorTO = this.consultaIdentificadorProprio();
            return identificadorTO.getNumeroTamanhoIdentificador();
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    public IdentificadorTO getIdentificadorTO() {
        try {
            IdentificadorTO identificadorTO = this.consultaIdentificadorProprio();
            return identificadorTO;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean existeIdenfificador() {
        try {
            IdentificadorTO identificadorTO = this.consultaIdentificadorProprio();
            return identificadorTO != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private FabricaDeControladorDeAcesso getFabricaDeControladorDeAcesso() {
        return FabricaDeControladorDeAcesso.getInstancia();
    }

    private String getMensagem(String mensagem, String ... parametros) {
        return UtilMensagem.getInstancia().getMensagem(mensagem, parametros);
    }

    public BBJMaskLabel criaIdentificadorProprio(int posicaoLabel, int largura, int larguraLabel) {
        String titulo = this.obtenhaTitulo();
        BBJMaskLabel txtIdentificadorProprio = new BBJMaskLabel(String.valueOf(titulo) + doisPontos, true, posicaoLabel, largura, larguraLabel);
        String mascara = this.obtenhaMascara();
        txtIdentificadorProprio.getJtfCampo().clean();
        txtIdentificadorProprio.getJtfCampo().setUpperCase(true);
        txtIdentificadorProprio.getJtfCampo().setMask(mascara);
        txtIdentificadorProprio.setToolTipText(this.getMensagem("MH026", titulo));
        return txtIdentificadorProprio;
    }

    private String obtenhaTitulo() {
        String titulo = UtilIdentificadorProprio.getInstancia().existeIdenfificador() ? (UtilString.isVazio(UtilIdentificadorProprio.getInstancia().getNomeIdentificadorProprio()) ? "Identificador Pr\u00f3prio" : UtilIdentificadorProprio.getInstancia().getNomeIdentificadorProprio()) : "";
        return titulo;
    }

    private String obtenhaMascara() {
        IdentificadorTO identificadorTO = UtilIdentificadorProprio.getInstancia().getIdentificadorTO();
        String mascara = identificadorTO != null ? (identificadorTO.getIndicadorDominio().charValue() == 'A' ? identificadorTO.getTextoMascara().replace("9", "@") : identificadorTO.getTextoMascara().replace("9", "#")) : "";
        return mascara;
    }

    public boolean houveAlteracaoIdentificadorProprioDaSessao(BBJMaskLabel bbjMaskLabel) {
        return UtilObjeto.isReferencia(bbjMaskLabel) && (this.houveMudancaNoTitulo(bbjMaskLabel) || this.houveMudancaNaMascara(bbjMaskLabel));
    }

    private boolean houveMudancaNaMascara(BBJMaskLabel bbjMaskLabel) {
        return UtilObjeto.isReferencia(bbjMaskLabel.getMask()) && !bbjMaskLabel.getMask().equals(this.obtenhaMascara());
    }

    private boolean houveMudancaNoTitulo(BBJMaskLabel bbjMaskLabel) {
        return UtilObjeto.isReferencia(bbjMaskLabel.getTitulo()) && !bbjMaskLabel.getTitulo().equals(String.valueOf(UtilIdentificadorProprio.getInstancia().getNomeIdentificadorProprio()) + doisPontos);
    }

    public void altera(BBJMaskLabel txtIdentificadorProprio) {
        txtIdentificadorProprio.setTitulo(String.valueOf(this.obtenhaTitulo()) + doisPontos);
        txtIdentificadorProprio.getJtfCampo().clean();
        txtIdentificadorProprio.getJtfCampo().setUpperCase(true);
        txtIdentificadorProprio.getJtfCampo().setMask(this.obtenhaMascara());
        txtIdentificadorProprio.setToolTipText(this.getMensagem("MH026", this.obtenhaTitulo()));
    }

    public IdentificadorProprioConvenenteServicoTO consultaIdentificadorProprioConvenenteServicoPor(ConvenenteTO convenenteTO, String servicoAtual) {
        return this.getIdentificadorProprioConvenenteServicoFacade().consultaIdentificadorProprioConvenenteServicoPor(convenenteTO, servicoAtual);
    }

    public String getTextoIdentificador() {
        if (this.existeIdenfificador()) {
            return this.consultaIdentificadorProprio().getId().getTextoIdentificador();
        }
        return "";
    }

    public Integer getCodigoTipoDocumento() {
        if (this.existeIdenfificador()) {
            return this.consultaIdentificadorProprio().getId().getCodigoTipoDocumento();
        }
        return 0;
    }
}

