/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.arquivo;

import br.com.bb.plugins.gac.util.arquivo.MoveArquivosUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class AlarmeUtil {
    private final ScheduledExecutorService fScheduler;
    private final long fInitialDelay;
    private final long fDelayBetweenRuns;
    private final long fShutdownAfter;
    private static final int NUM_THREADS = 3;
    private static final boolean DONT_INTERRUPT_IF_RUNNING = false;

    public static void main(String ... aArgs) throws InterruptedException {
        AlarmeUtil monitoraDiretorio = new AlarmeUtil(5L, 3600L, 1800L);
        monitoraDiretorio.iniciaTarefa();
    }

    AlarmeUtil(long aInitialDelay, long aDelayBetweenBeeps, long aStopAfter) {
        this.fInitialDelay = aInitialDelay;
        this.fDelayBetweenRuns = aDelayBetweenBeeps;
        this.fShutdownAfter = aStopAfter;
        this.fScheduler = Executors.newScheduledThreadPool(3);
    }

    void iniciaTarefa() {
        TarefaContrato tarefaContrato = new TarefaContrato();
        TarefaRetorno tarefaRetorno = new TarefaRetorno();
        TarefaRemessa tarefaRemessa = new TarefaRemessa();
        ScheduledFuture<?> contratoTaskFuture = this.fScheduler.scheduleWithFixedDelay(tarefaContrato, this.fInitialDelay, this.fDelayBetweenRuns, TimeUnit.SECONDS);
        ScheduledFuture<?> retornoTaskFuture = this.fScheduler.scheduleWithFixedDelay(tarefaRetorno, this.fInitialDelay, this.fDelayBetweenRuns, TimeUnit.SECONDS);
        ScheduledFuture<?> remessaTaskFuture = this.fScheduler.scheduleWithFixedDelay(tarefaRemessa, this.fInitialDelay, this.fDelayBetweenRuns, TimeUnit.SECONDS);
        ParaTarefa paraAlarmeContrato = new ParaTarefa(contratoTaskFuture);
        ParaTarefa paraAlarmeRetorno = new ParaTarefa(retornoTaskFuture);
        ParaTarefa paraAlarmeRemessa = new ParaTarefa(remessaTaskFuture);
        this.fScheduler.schedule(paraAlarmeContrato, this.fShutdownAfter, TimeUnit.SECONDS);
        this.fScheduler.schedule(paraAlarmeRetorno, this.fShutdownAfter, TimeUnit.SECONDS);
        this.fScheduler.schedule(paraAlarmeRemessa, this.fShutdownAfter, TimeUnit.SECONDS);
    }

    private static void log(String aMsg) {
        System.out.println(aMsg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ParaTarefa
    implements Runnable {
        private ScheduledFuture<?> fSchedFuture;

        ParaTarefa(ScheduledFuture<?> aSchedFuture) {
            this.fSchedFuture = aSchedFuture;
        }

        @Override
        public void run() {
            this.fSchedFuture.cancel(false);
            AlarmeUtil.this.fScheduler.shutdown();
        }
    }

    private static final class TarefaContrato
    implements Runnable {
        private TarefaContrato() {
        }

        public void run() {
            try {
                MoveArquivosUtil.contrato();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class TarefaRemessa
    implements Runnable {
        private TarefaRemessa() {
        }

        public void run() {
            try {
                MoveArquivosUtil.remessa();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class TarefaRetorno
    implements Runnable {
        private TarefaRetorno() {
        }

        public void run() {
            try {
                MoveArquivosUtil.retorno();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

