/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.arquivo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileInfo {
    private static final DateFormat FORMATTER = new SimpleDateFormat("dd/MM/yyyy  hh:mm");
    private File file;
    private boolean hasLoaded = false;
    private String owner;
    private Map<Timefield, Date> timefields = new HashMap<Timefield, Date>();

    public FileInfo(File file) {
        this.file = file;
    }

    private String getTimefieldSwitch(Timefield field) {
        switch (field) {
            case CREATED: {
                return "C";
            }
            case ACCESSED: {
                return "A";
            }
        }
        return "W";
    }

    private void shellToDir(Timefield timefield) throws IOException, ParseException {
        Runtime systemShell = Runtime.getRuntime();
        Process output = systemShell.exec(String.format("cmd /c dir /Q /R /T%s %s ", this.getTimefieldSwitch(timefield), this.file.getAbsolutePath()));
        BufferedReader reader = new BufferedReader(new InputStreamReader(output.getInputStream()));
        String outputLine = null;
        while ((outputLine = reader.readLine()) != null) {
            if (!outputLine.contains(this.file.getName())) continue;
            this.timefields.put(timefield, FORMATTER.parse(outputLine.substring(0, 17)));
            this.owner = outputLine.substring(36, 59);
        }
    }

    private void load() throws IOException, ParseException {
        if (this.hasLoaded) {
            return;
        }
        this.shellToDir(Timefield.CREATED);
        this.shellToDir(Timefield.ACCESSED);
        this.shellToDir(Timefield.WRITTEN);
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public long getSize() {
        return this.file.length();
    }

    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    public String getOwner() throws IOException, ParseException {
        this.load();
        return this.owner;
    }

    public Date getCreated() throws IOException, ParseException {
        this.load();
        return this.timefields.get((Object)Timefield.CREATED);
    }

    public Date getAccessed() throws IOException, ParseException {
        this.load();
        return this.timefields.get((Object)Timefield.ACCESSED);
    }

    public Date getWritten() throws IOException, ParseException {
        this.load();
        return this.timefields.get((Object)Timefield.WRITTEN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Timefield {
        CREATED,
        ACCESSED,
        WRITTEN;

    }
}

