/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.assinaturadigital;

import br.com.bb.cdbb.apresentacao.SwingCDGA3;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.AssinaturaDigitalFacade;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class UtilAssinaturaDigitalLock {
    private static File arquivo;
    private static FileLock lock;
    private static FileChannel channel;
    private static RemessaTODecorator remessaTODecorator;

    public static void assina() {
        block5: {
            try {
                if (arquivo != null && lock != null) {
                    Boolean habilitadaAssinaturaDigital = UtilAssinaturaDigitalLock.getAssinaturaDigitalFacade().habilitadaAssinaturaDigital();
                    if (habilitadaAssinaturaDigital.booleanValue()) {
                        SwingCDGA3.get().setArquivo(arquivo);
                        SwingCDGA3.get().assinaOArquivoComCertificado();
                        UtilAssinaturaDigitalLock.atualizaRemessa();
                        lock.release();
                        channel.close();
                        UtilAssinaturaDigitalLock.removeArquivoRemessa();
                    }
                    break block5;
                }
                throw new BBException("Erro ao obter o arquivo para assinar.");
            }
            catch (BBException e) {
                BBJPopupMensagem.exibirMensagemErro(e.getMessage());
            }
            catch (IOException e) {
                BBJPopupMensagem.exibirMensagemErro("Erro ao liberar o acesso exclusivo do arquivo.");
            }
        }
    }

    private static void removeArquivoRemessa() throws BBException {
        if (SwingCDGA3.get().isArquivoAssinado()) {
            arquivo.delete();
        }
    }

    private static void atualizaRemessa() throws BBException {
        if (SwingCDGA3.get().isArquivoAssinado()) {
            remessaTODecorator.getRemessaTO().setTextoNomeArquivo(SwingCDGA3.get().getNomeArquivoAssinado());
            FacadeFactory.getInstancia().novoRemessaFacade().getRemessaModel().getRemessaDAO().alterar(remessaTODecorator.getRemessaTO());
        }
    }

    private static AssinaturaDigitalFacade getAssinaturaDigitalFacade() {
        return FacadeFactory.getInstancia().novoAssinaturaDigitalFacade();
    }

    public static void setArquivo(File arquivo_) {
        arquivo = arquivo_;
        try {
            channel = new RandomAccessFile(arquivo, "rw").getChannel();
            lock = channel.lock();
        }
        catch (Exception e) {
            BBJPopupMensagem.exibirMensagemErro("Erro ao obter acesso exclusivo no arquivo para assinatura.");
        }
    }

    public static void setRemessaTODecorator(RemessaTODecorator _remessaTODecorator) {
        remessaTODecorator = _remessaTODecorator;
    }

    public static void assinaArquivoSelecionadoPeloUsuario() throws BBException {
        SwingCDGA3.get().setArquivo(arquivo);
        SwingCDGA3.get().assinaOArquivoComCertificado();
        UtilAssinaturaDigitalLock.removeArquivoRemessa();
    }
}

