/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.controller.view;

import br.com.bb.plugins.gac.apresentacao.configurarbancodados.view.ViewConfigurarBancoDadosPopup;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.DAO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import java.io.File;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ApplicationContextFactory {
    private ApplicationContext applicationContext;
    private static ApplicationContextFactory instance;
    private String[] arquivos = new String[]{"Application-context.xml", "contextos/dao-context.xml", "contextos/dominio-context.xml", "contextos/facade-context.xml", "contextos/Menu-infra-context.xml", "contextos/model-context.xml", "classpath:META-INF/services/*points.xml", "classpath:META-INF/services/extension-points.xml", "classpath:META-INF/services/bootstrap.xml", "classpath*:META-INF/services/*.ctx.xml"};
    private String[] arquivosConfiguracaoMinima = new String[]{"Application-context.xml", "contextos/dao-context.xml", "contextos/dominio-context.xml", "contextos/facade-context.xml", "contextos/Menu-infra-context.xml", "contextos/model-context.xml"};
    private static ConfiguracaoProperties configuracaoProperties;

    static {
        configuracaoProperties = ConfiguracaoProperties.getConfiguracaoProperties();
    }

    private ApplicationContextFactory() {
    }

    public static ApplicationContextFactory getInstance() {
        if (instance == null) {
            instance = new ApplicationContextFactory();
        }
        return instance;
    }

    public void unload() {
        this.applicationContext = null;
    }

    public void load() {
        this.applicationContext = new ClassPathXmlApplicationContext(this.arquivos);
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            try {
                if (this.problemaBD()) {
                    this.applicationContext = new ClassPathXmlApplicationContext(this.arquivosConfiguracaoMinima);
                    this.solicitaConfiguracao();
                } else {
                    System.out.println(ConfiguracaoProperties.getConfiguracaoProperties());
                    this.applicationContext = new ClassPathXmlApplicationContext(this.arquivos);
                }
                ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String dir = System.getProperty("user.dir");
                File f = new File(String.valueOf(dir) + System.getProperty("file.separator") + "BBGAC.properties");
                if (f.exists()) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, exception.getMessage());
                    this.solicitaConfiguracao();
                }
                ViewConfigurarBancoDadosPopup config = new ViewConfigurarBancoDadosPopup(null);
                config.setModal(true);
                config.doShow(null);
            }
        }
        return this.applicationContext;
    }

    private void solicitaConfiguracao() {
        ViewConfigurarBancoDadosPopup config = new ViewConfigurarBancoDadosPopup(null);
        config.setModal(true);
        config.doShow(null);
        try {
            configuracaoProperties.salvaPropriedades();
        }
        catch (BBException e) {
            e.printStackTrace();
        }
    }

    private boolean problemaBD() {
        return ConfiguracaoProperties.getConfiguracaoProperties().getBancoTemProblema().equals("1");
    }

    public static Session getCurrentSession() {
        SessionFactory bean = (SessionFactory)ApplicationContextFactory.getInstance().getApplicationContext().getBean("hibernateSessionFactory");
        return bean.getCurrentSession();
    }

    public static void disconnectSession() {
        if (ApplicationContextFactory.getInstance().getApplicationContext() != null) {
            String[] beans;
            String[] stringArray = beans = ApplicationContextFactory.getInstance().getApplicationContext().getBeanDefinitionNames();
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Object beanObject;
                String beanName = stringArray[n2];
                if (beanName.indexOf("DAO") > -1 && beanName.indexOf("templateDAO") == -1) {
                    beanObject = ApplicationContextFactory.getInstance().getApplicationContext().getBean(beanName);
                    if (beanObject instanceof DAO) {
                        ((DAO)beanObject).closeSession();
                        beanObject = null;
                    }
                } else if (beanName.equalsIgnoreCase("dataSource")) {
                    beanObject = ApplicationContextFactory.getInstance().getApplicationContext().getBean(beanName);
                    try {
                        ((BasicDataSource)beanObject).close();
                        beanObject = null;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else if (beanName.equalsIgnoreCase("hibernateSessionFactory") && (beanObject = (SessionFactory)ApplicationContextFactory.getInstance().getApplicationContext().getBean(beanName)) != null && !beanObject.isClosed()) {
                    beanObject.close();
                    beanObject = null;
                }
                ++n2;
            }
        }
    }
}

