/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.dominio;

import br.com.bb.plugins.gac.negocio.to.DominioTO;
import br.com.bb.plugins.gac.util.dominio.UtilXMLDominios;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.validador.UtilValidadorDeNumerosIguais;
import br.com.politec.infra.util.excecao.UtilInfraRuntimeException;
import br.com.politec.xml.excecao.XmlException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UtilArquivoDominio {
    private static UtilArquivoDominio instancia = new UtilArquivoDominio();
    private Map mapaDominios;

    private UtilArquivoDominio() {
    }

    public static UtilArquivoDominio getInstancia() {
        return instancia;
    }

    public void carregarDominios() {
        try {
            this.setMapaDominios(UtilXMLDominios.getDominios());
        }
        catch (XmlException e) {
            throw UtilInfraRuntimeException.erro(e);
        }
    }

    public Collection getDominio(String id) {
        return (Collection)this.getMapaDominios().get(id);
    }

    private Map getMapaDominios() {
        if (!UtilObjeto.isReferencia(this.mapaDominios)) {
            this.carregarDominios();
        }
        return this.mapaDominios;
    }

    private void setMapaDominios(Map mapaDominios) {
        this.mapaDominios = mapaDominios;
    }

    public String getDescricaoDominioTOPorChave(Collection colecaoDominioTO, int chave) {
        String descricao = "";
        List lista = (List)colecaoDominioTO;
        for (DominioTO to : lista) {
            if (!UtilValidadorDeNumerosIguais.validar(to.getCodigo(), chave)) continue;
            descricao = to.getDescricao();
            break;
        }
        return descricao;
    }
}

