/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.dominio;

import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.DominioTO;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.numerico.UtilNumero;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.xml.UtilXmlDOM;
import br.com.politec.xml.excecao.XmlException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class UtilXMLDominios {
    private UtilXMLDominios() {
    }

    public static Map getDominios() throws XmlException {
        Document document = UtilXMLDominios.parserXml();
        Element root = UtilXMLDominios.getRoot(document);
        Collection dominios = UtilXMLDominios.getDominios(root);
        return UtilXMLDominios.getMapaDeDominios(dominios.iterator());
    }

    private static Document parserXml() throws XmlException {
        String pathXml = UtilXMLDominios.getPathDoXML();
        InputStream xml = UtilArquivo.getInputStream(pathXml);
        return UtilXmlDOM.getDocumento(xml, false);
    }

    private static Element getRoot(Document document) {
        return UtilXmlDOM.getRoot(document);
    }

    private static Collection getDominios(Element root) {
        return UtilXmlDOM.getElementos(root);
    }

    private static Map getMapaDeDominios(Iterator iterator) {
        Map mapa = UtilXMLDominios.getColecaoFactory().novoHashMap();
        while (iterator.hasNext()) {
            Element dominio = (Element)iterator.next();
            String id = UtilXmlDOM.getValorDoAtributo(dominio, "id");
            Collection valores = UtilXMLDominios.getValoresDoDominio(dominio);
            mapa.put(id, valores);
        }
        return mapa;
    }

    private static Collection getValoresDoDominio(Element dominio) {
        List resultado = UtilXMLDominios.getColecaoFactory().novoArrayList();
        Collection colecao = UtilXmlDOM.getElementos(dominio);
        for (Element opcao : colecao) {
            String valor = UtilXmlDOM.getValorDoAtributo(opcao, "valor");
            String modelo = UtilXmlDOM.getValorDoAtributo(opcao, "modelo");
            String descricao = UtilXMLDominios.getTexto(opcao);
            if (modelo == null) {
                resultado.add(UtilXMLDominios.novoDominioTO(valor, descricao));
                continue;
            }
            resultado.add(UtilXMLDominios.novoDominioTO(valor, descricao, modelo));
        }
        return resultado;
    }

    private static DominioTO novoDominioTO(String valor, String descricao, String modelo) {
        DominioTO to = null;
        if (UtilNumero.isInteiro(valor)) {
            int codigo = UtilConversorDeInteger.converterParaPrimitivo(valor);
            to = UtilXMLDominios.getTOFactory().novoDominioTO(codigo, descricao);
        } else {
            to = UtilXMLDominios.getTOFactory().novoDominioTO(valor, descricao);
        }
        to.setModelo(modelo);
        return to;
    }

    private static DominioTO novoDominioTO(String valor, String descricao) {
        DominioTO to = null;
        if (UtilNumero.isInteiro(valor)) {
            int codigo = UtilConversorDeInteger.converterParaPrimitivo(valor);
            to = UtilXMLDominios.getTOFactory().novoDominioTO(codigo, descricao);
        } else {
            to = UtilXMLDominios.getTOFactory().novoDominioTO(valor, descricao);
        }
        return to;
    }

    private static String getPathDoXML() {
        String pathCompleto = Arquivo.getPathDominio();
        return pathCompleto;
    }

    private static String getTexto(Element opcao) {
        StringBuffer resultado = new StringBuffer();
        NodeList lista = opcao.getChildNodes();
        if (UtilObjeto.isReferencia(lista)) {
            int indice = 0;
            while (indice < lista.getLength()) {
                Node node = lista.item(indice);
                if (UtilObjeto.isObjetoDoTipo(node, Text.class)) {
                    resultado.append(((Text)node).getNodeValue());
                }
                ++indice;
            }
        }
        return resultado.toString();
    }

    private static TOFactory getTOFactory() {
        return TOFactory.getInstancia();
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }
}

