/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.interceptor;

import br.com.bb.plugins.gac.excecao.CobrancaException;
import br.com.bb.plugins.gac.excecao.ExceptionManager;
import java.lang.reflect.Method;
import org.springframework.aop.ThrowsAdvice;

public class TranslateExceptionInterceptor
implements ThrowsAdvice {
    private ExceptionManager exManager;

    public TranslateExceptionInterceptor(ExceptionManager exManager) {
        this.exManager = exManager;
    }

    public void afterThrowing(Method m, Object[] args, Object target, CobrancaException ex) {
        String errorCode = null;
        String[] macros = null;
        if (ex.getCause() instanceof CobrancaException) {
            CobrancaException cause = (CobrancaException)ex.getCause();
            errorCode = cause.getErrorCode();
            macros = cause.getMacros();
        } else {
            errorCode = ex.getErrorCode();
            macros = ex.getMacros();
        }
        ex.setBusinessMessage(this.exManager.traduzir(errorCode, macros));
    }
}

