/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.net.proxy;

import br.com.bb.plugins.gac.apresentacao.configurardadosservidorproxy.action.RecuperarDadosServidorProxyAction;
import br.com.bb.plugins.gac.apresentacao.configurardadosservidorproxy.form.DadosServidorProxyForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ActionFactory;
import br.com.bb.plugins.gac.factory.FormFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBGACSelecionadorProxy
extends ProxySelector {
    ProxySelector defsel = null;
    HashMap<SocketAddress, InnerProxy> proxies = new HashMap();

    BBGACSelecionadorProxy(ProxySelector def) {
        this.defsel = def;
        try {
            DadosServidorProxyForm dadosServidorProxyForm = (DadosServidorProxyForm)FormFactory.getInstancia().novoDadosServidorProxyForm();
            RecuperarDadosServidorProxyAction recuperarDadosServidorProxyAction = ActionFactory.getInstancia().novoRecuperarDadosServidorProxyAction();
            recuperarDadosServidorProxyAction.executar(dadosServidorProxyForm);
            System.setProperty("http.proxyHost", dadosServidorProxyForm.getEndereco());
            System.setProperty("http.proxyPort", dadosServidorProxyForm.getPorta());
            InnerProxy i = new InnerProxy(new InetSocketAddress(dadosServidorProxyForm.getEndereco(), (int)new Integer(dadosServidorProxyForm.getPorta())));
            this.proxies.put(i.address(), i);
        }
        catch (BBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
            ArrayList<Proxy> l = new ArrayList<Proxy>();
            for (InnerProxy p : this.proxies.values()) {
                l.add(p.toProxy());
            }
            return l;
        }
        if (this.defsel != null) {
            return this.defsel.select(uri);
        }
        ArrayList<Proxy> l = new ArrayList<Proxy>();
        l.add(Proxy.NO_PROXY);
        return l;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        InnerProxy p = this.proxies.get(sa);
        if (p != null) {
            if (p.failed() >= 3) {
                this.proxies.remove(sa);
            }
        } else if (this.defsel != null) {
            this.defsel.connectFailed(uri, sa, ioe);
        }
    }

    class InnerProxy {
        Proxy proxy;
        SocketAddress addr;
        int failedCount = 0;

        InnerProxy(InetSocketAddress a) {
            this.addr = a;
            this.proxy = new Proxy(Proxy.Type.HTTP, a);
        }

        SocketAddress address() {
            return this.addr;
        }

        Proxy toProxy() {
            return this.proxy;
        }

        int failed() {
            return ++this.failedCount;
        }
    }
}

