/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.objecttablemodel;

import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.util.Utilitarios;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;

public class DadosDocumento
extends IObjectTableModel {
    private IdentificacaoTO identificacaoTO;

    public IdentificacaoTO getIdentificacaoTO() {
        if (this.identificacaoTO == null) {
            this.identificacaoTO = TOFactory.getInstancia().novoIdentificacaoTO();
        }
        return this.identificacaoTO;
    }

    public void setIdentificacaoTO(IdentificacaoTO identificacaoTO) {
        this.identificacaoTO = identificacaoTO;
    }

    public DadosDocumento(IdentificacaoTO identificacaoTO) {
        this.setIdentificacaoTO(identificacaoTO);
    }

    public Object getColumn(int column) {
        switch (column) {
            case 0: {
                return this.textoTipoDocumento(this.getIdentificacaoTO());
            }
            case 1: {
                return this.formataCPFouCNPJ(this.getDocumento(), this.getTipoDocumento());
            }
        }
        return null;
    }

    private String textoTipoDocumento(IdentificacaoTO identificacaoTO) {
        if (identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento().equals(10)) {
            return identificacaoTO.getIdentificadorTO().getNomeIdentificador();
        }
        return identificacaoTO.getTipoDocumentoTO().getTextoDescricao();
    }

    private String formataCPFouCNPJ(String documento, String tipoDocumento) {
        if (tipoDocumento.equals("CPF") || tipoDocumento.equals("CNPJ")) {
            return Utilitarios.formatarCPFouCNPJ(documento);
        }
        return documento;
    }

    public String getDocumento() {
        return this.getIdentificacaoTO().getId().getTextoIdentificacao();
    }

    private TipoDocumentoTO getTipoDocumentoTO() {
        return this.getIdentificacaoTO().getTipoDocumentoTO();
    }

    public void setDocumento(String documento) {
        this.getIdentificacaoTO().getId().setTextoIdentificacao(documento);
    }

    public String getTipoDocumento() {
        return this.getTipoDocumentoTO().getTextoDescricao();
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.getTipoDocumentoTO().setTextoDescricao(tipoDocumento);
    }

    public PluginTOAbstrato getTO() {
        return this.getIdentificacaoTO();
    }
}

