/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo.conversor;

import br.com.bb.plugins.gac.util.parserarquivo.bean.CampoBean;
import br.com.bb.plugins.gac.util.parserarquivo.conversor.PluginConversorAbstrato;
import br.com.politec.generico.conversor.UtilConversorDeData;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.pattern.UtilPatternsDeData;
import br.com.politec.generico.string.UtilString;
import br.com.politec.xml.util.UtilLog;

public class ConversorDeStringParaData
extends PluginConversorAbstrato {
    public Object converter(Object objeto) throws ConversorException {
        if (this.isCampoBean(objeto)) {
            CampoBean campoBean = this.getCampoBean(objeto);
            String valor = this.getValor(campoBean);
            String formato = this.getFormato(campoBean);
            campoBean.setValor(this.converterParaData(valor, formato));
        }
        return objeto;
    }

    protected Object converterParaData(String valor, String formato) {
        try {
            if (this.validarData(valor)) {
                return UtilConversorDeData.converter(valor, formato);
            }
        }
        catch (RuntimeException e) {
            UtilLog.getLog().debug(e.getMessage());
        }
        return null;
    }

    private boolean validarData(String valor) {
        if (valor == null) {
            return false;
        }
        String texto = UtilString.removerCaracteres(valor);
        return texto != null && texto.trim().length() >= 8;
    }

    protected String getFormato(CampoBean campoBean) {
        String formato = this.converterFormato(campoBean.getFormato());
        if (this.isVazio(formato)) {
            formato = UtilPatternsDeData.getddMMyyyy();
        }
        return formato;
    }

    protected String converterFormato(String formato) {
        formato = UtilString.substituirString(formato, "[A]", "y");
        formato = UtilString.substituirString(formato, "[D]", "d");
        return formato;
    }
}

