/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo.conversor;

import br.com.bb.plugins.gac.util.parserarquivo.bean.CampoBean;
import br.com.bb.plugins.gac.util.parserarquivo.conversor.PluginConversorAbstrato;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.validador.UtilValidadorDeNumeroInicialMaiorQueNumeroFinal;
import java.math.BigDecimal;

public class ConversorDeStringParaNumerico
extends PluginConversorAbstrato {
    public Object converter(Object objeto) throws ConversorException {
        if (this.isCampoBean(objeto)) {
            CampoBean campoBean = this.getCampoBean(objeto);
            String valor = this.getValor(campoBean);
            Integer decimais = this.getDecimais(campoBean);
            Integer tamanho = this.getTamanho(campoBean);
            campoBean.setValor(this.converterParaNumerico(valor, decimais, tamanho));
        }
        return objeto;
    }

    protected Object converterParaNumerico(String valor, Integer decimais, Integer tamanho) {
        Number resultado = null;
        if (valor == null || valor.trim().length() == 0) {
            return 0;
        }
        resultado = this.isZero(decimais) ? (Number)this.converterParaNumeroSemCasasDecimais(valor.trim(), tamanho) : (Number)this.converterParaNumeroComCasasDecimais(valor.trim(), decimais);
        return resultado;
    }

    protected Number converterParaNumeroSemCasasDecimais(String valor, Integer tamanho) {
        Number resultado = null;
        if (valor == null || valor.trim().length() == 0) {
            return 0;
        }
        resultado = UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(tamanho, 9) ? (Number)UtilConversorDeString.converterParaLong(valor.trim()) : (Number)UtilConversorDeString.converterParaInteger(valor.trim());
        return resultado;
    }

    protected Number converterParaNumeroComCasasDecimais(String valor, Integer decimais) {
        if (valor == null || valor.trim().length() == 0) {
            return 0.0;
        }
        BigDecimal bd = null;
        bd = UtilConversorDeString.converterParaBigDecimal(valor.trim(), decimais);
        return bd.doubleValue();
    }
}

