/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo.util;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ConversorFactory;
import br.com.bb.plugins.gac.factory.PrototypeFactory;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.constante.TipoDeCampo;
import br.com.bb.plugins.gac.util.parserarquivo.bean.ArquivoBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.CampoBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.RegistroBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.ServicoBean;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.conversor.instancia.IConversor;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UtilParserArquivoTXT {
    private static Map<String, IConversor> mapaDeConversores;

    public static Map<String, Collection<RegistroBean>> parser(ServicoBean servicoBean, File arquivo) throws BBException {
        Map resultado = UtilParserArquivoTXT.novoHashMap();
        String servico = UtilParserArquivoTXT.getServico(arquivo);
        ArquivoBean arquivoBean = UtilParserArquivoTXT.getArquivoBean(servicoBean, servico);
        BufferedReader br = UtilArquivo.getBufferedReader(arquivo);
        try {
            try {
                UtilParserArquivoTXT.percorrerLinhasDoArquivo(br, arquivoBean, resultado);
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
        finally {
            try {
                br.close();
                br = null;
            }
            catch (IOException e) {
                UtilParserArquivoTXT.getLog().logMsg(e);
            }
        }
        return resultado;
    }

    private static void percorrerLinhasDoArquivo(BufferedReader reader, ArquivoBean arquivoBean, Map<String, Collection<RegistroBean>> resultado) throws IOException, BBException {
        String linha = reader.readLine();
        if (UtilParserArquivoTXT.isReferencia(linha)) {
            String tipo = UtilParserArquivoTXT.getTipoDeRegistro(linha);
            RegistroBean registro = arquivoBean.getRegistro(tipo);
            RegistroBean copiaRegistro = UtilParserArquivoTXT.novoRegistroBean(registro);
            UtilParserArquivoTXT.parser(copiaRegistro, linha);
            UtilParserArquivoTXT.adicionarRegistroBeanNaColecaoDeRegistros(tipo, resultado, copiaRegistro);
            UtilParserArquivoTXT.percorrerLinhasDoArquivo(reader, arquivoBean, resultado);
        }
    }

    private static void adicionarRegistroBeanNaColecaoDeRegistros(String tipo, Map<String, Collection<RegistroBean>> resultado, RegistroBean copiaRegistro) {
        Collection<RegistroBean> collection = UtilParserArquivoTXT.getColecaoDeRegistroDoTipo(tipo, resultado);
        collection.add(copiaRegistro);
    }

    private static Collection<RegistroBean> getColecaoDeRegistroDoTipo(String tipo, Map<String, Collection<RegistroBean>> resultado) {
        List colecao = resultado.get(tipo);
        if (!UtilParserArquivoTXT.isReferencia(colecao)) {
            colecao = UtilParserArquivoTXT.novoArrayList();
            resultado.put(tipo, colecao);
        }
        return colecao;
    }

    private static void parser(RegistroBean registro, String linha) throws BBException {
        List<CampoBean> campos = registro.getListaDeCampos();
        int posicaoAtual = 0;
        for (CampoBean campo : campos) {
            UtilParserArquivoTXT.carregarValorDoRegistro(campo, linha, posicaoAtual);
            posicaoAtual += campo.getTamanho().intValue();
        }
    }

    private static void carregarValorDoRegistro(CampoBean campo, String linha, Integer posicaoAtual) throws BBException {
        Object valor = campo.getValor();
        if (!UtilParserArquivoTXT.isReferencia(valor)) {
            Integer tamanho = campo.getTamanho();
            Integer posicaoFinal = posicaoAtual + tamanho;
            valor = UtilString.substring(linha, posicaoAtual, posicaoFinal);
            campo.setValor(valor);
        }
        UtilParserArquivoTXT.aplicarConversorNoValorDoCampo(campo);
    }

    private static void aplicarConversorNoValorDoCampo(CampoBean campo) throws BBException {
        try {
            IConversor conversor = UtilParserArquivoTXT.getConversor(campo.getTipo());
            conversor.converter(campo);
        }
        catch (ConversorException e) {
            throw UtilBBException.getErroDeSistema(e);
        }
    }

    private static String getTipoDeRegistro(String linha) {
        return UtilString.substring(linha, 0, 1);
    }

    private static ArquivoBean getArquivoBean(ServicoBean servicoBean, String servico) {
        return servicoBean.getArquivoBean(servico);
    }

    private static String getServico(File arquivo) {
        String nome = UtilParserArquivoTXT.getNomeDoArquivo(arquivo);
        return UtilString.substring(nome, 0, 3);
    }

    private static String getNomeDoArquivo(File arquivo) {
        return arquivo.getName();
    }

    private static RegistroBean novoRegistroBean(RegistroBean registro) {
        return UtilParserArquivoTXT.getPrototypeFactory().novoRegistroBean(registro);
    }

    private static IConversor getConversor(String tipoDeCampo) {
        IConversor conversor = UtilParserArquivoTXT.getMapaDeConversores().get(tipoDeCampo);
        if (!UtilParserArquivoTXT.isReferencia(conversor)) {
            conversor = UtilParserArquivoTXT.getConversorFactory().novoConversorDeStringParaString();
        }
        return conversor;
    }

    private static Log getLog() {
        return Log.getInstance();
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    private static Map novoHashMap() {
        return UtilParserArquivoTXT.getColecaoFactory().novoHashMap();
    }

    private static List novoArrayList() {
        return UtilParserArquivoTXT.getColecaoFactory().novoArrayList();
    }

    private static Map<String, IConversor> getMapaDeConversores() {
        if (!UtilParserArquivoTXT.isReferencia(mapaDeConversores)) {
            mapaDeConversores = UtilParserArquivoTXT.novoHashMap();
            mapaDeConversores.put(TipoDeCampo.getString(), UtilParserArquivoTXT.getConversorFactory().novoConversorDeStringParaString());
            mapaDeConversores.put(TipoDeCampo.getNumerico(), UtilParserArquivoTXT.getConversorFactory().novoConversorDeStringParaNumerico());
            mapaDeConversores.put(TipoDeCampo.getData(), UtilParserArquivoTXT.getConversorFactory().novoConversorDeStringParaData());
        }
        return mapaDeConversores;
    }

    private static ConversorFactory getConversorFactory() {
        return ConversorFactory.getInstancia();
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    private static PrototypeFactory getPrototypeFactory() {
        return PrototypeFactory.getInstancia();
    }
}

