/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo.util;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.BeanFactory;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.parserarquivo.bean.ArquivoBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.CampoBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.RegistroBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.ServicoBean;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.xml.UtilXmlDOM;
import br.com.politec.xml.excecao.XmlException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UtilParserArquivoXML {
    private static Map<String, ServicoBean> mapaServico;

    public static ServicoBean getServico(String servico, InputStream xml) throws BBException {
        ServicoBean sb = UtilParserArquivoXML.getServico(servico);
        if (!UtilParserArquivoXML.isReferencia(sb)) {
            sb = UtilParserArquivoXML.parser(servico, xml);
            UtilParserArquivoXML.getMapaServico().put(servico, sb);
        }
        return sb;
    }

    private static ServicoBean getServico(String servico) {
        return UtilParserArquivoXML.getMapaServico().get(servico);
    }

    private static ServicoBean parser(String servico, InputStream xml) throws BBException {
        Document document = UtilParserArquivoXML.getDocument(xml);
        ArquivoBean arquivoBean = UtilParserArquivoXML.getBeanFactory().novoArquivoBean();
        ServicoBean servicoBean = UtilParserArquivoXML.getBeanFactory().novoServicoBean(servico, arquivoBean);
        UtilParserArquivoXML.carregarArquivo(arquivoBean, document);
        return servicoBean;
    }

    private static void carregarArquivo(ArquivoBean arquivoBean, Document document) {
        Element root = UtilXmlDOM.getRoot(document);
        UtilParserArquivoXML.carregarRegistros(arquivoBean, root);
    }

    private static void carregarRegistros(ArquivoBean arquivoBean, Element root) {
        Collection registros = UtilXmlDOM.getElementos(root);
        for (Element registro : registros) {
            RegistroBean registroBean = UtilParserArquivoXML.novoRegistroBean(registro);
            UtilParserArquivoXML.adicionarRegistroNoArquivo(arquivoBean, registroBean);
            UtilParserArquivoXML.carregarCampos(registroBean, registro);
        }
    }

    private static void carregarCampos(RegistroBean registroBean, Element registro) {
        Collection campos = UtilXmlDOM.getElementos(registro);
        for (Element campo : campos) {
            CampoBean campoBean = UtilParserArquivoXML.novoCampoBean(campo);
            UtilParserArquivoXML.adicionarCampoNoRegistro(registroBean, campoBean);
        }
    }

    private static String getValorDoAtributo(Element elemento, String nome) {
        String valor = UtilXmlDOM.getValorDoAtributo(elemento, nome);
        return UtilParserArquivoXML.isVazio(valor = UtilString.trim(valor)) ? null : valor;
    }

    private static Integer getValorDoAtributoInteger(Element elemento, String nome) {
        String valor = UtilParserArquivoXML.getValorDoAtributo(elemento, nome);
        return UtilConversorDeString.converterParaInt(valor);
    }

    private static CampoBean novoCampoBean(Element campo) {
        return UtilParserArquivoXML.getBeanFactory().novoCampoBean(UtilParserArquivoXML.getValorDoAtributo(campo, "Nome"), UtilParserArquivoXML.getValorDoAtributo(campo, "Tipo"), UtilParserArquivoXML.getValorDoAtributoInteger(campo, "Tamanho"), UtilParserArquivoXML.getValorDoAtributo(campo, "Formato"), UtilParserArquivoXML.getValorDoAtributoInteger(campo, "Decimais"), UtilParserArquivoXML.getValorDoAtributo(campo, "Valor"));
    }

    private static RegistroBean novoRegistroBean(Element registro) {
        return UtilParserArquivoXML.getBeanFactory().novoRegistroBean(UtilParserArquivoXML.getValorDoAtributo(registro, "Nome"), UtilParserArquivoXML.getValorDoAtributoInteger(registro, "Tamanho"), UtilParserArquivoXML.getValorDoAtributo(registro, "Identificador"), UtilParserArquivoXML.getValorDoAtributo(registro, "Descricao"));
    }

    private static Document getDocument(InputStream xml) throws BBException {
        Document document = null;
        try {
            document = UtilXmlDOM.getDocumento(xml, false);
        }
        catch (XmlException e) {
            throw UtilBBException.getErroDeSistema(e);
        }
        return document;
    }

    private static Map<String, ServicoBean> getMapaServico() {
        if (!UtilObjeto.isReferencia(mapaServico)) {
            mapaServico = new HashMap<String, ServicoBean>();
        }
        return mapaServico;
    }

    private static void adicionarRegistroNoArquivo(ArquivoBean arquivoBean, RegistroBean registroBean) {
        String nome = registroBean.getNome();
        arquivoBean.getMapaDeRegistros().put(nome, registroBean);
    }

    private static void adicionarCampoNoRegistro(RegistroBean registroBean, CampoBean campoBean) {
        registroBean.getListaDeCampos().add(campoBean);
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    private static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    private static BeanFactory getBeanFactory() {
        return BeanFactory.getInstancia();
    }
}

