/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.seguranca;

import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.FabricaDeServiceLocator;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.VerificarPermissaoFacade;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.util.ServiceLocator;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.exception.InfraRuntimeException;
import br.com.politec.infra.seguranca.ControladorDeAcesso;
import br.com.politec.infra.transacao.Transacao;

public class PluginControladorDeAcesso
extends ControladorDeAcesso {
    private static PluginProfile profile;

    public PluginProfile novoProfile(UsuarioTO usuarioTO) {
        PluginProfile profile = null;
        profile = this.getFabricaDeControladorDeAcesso().novoPluginProfile();
        profile.setUsuarioTO(usuarioTO);
        this.setProfile(profile);
        return profile;
    }

    public void setProfile(ControladorDeAcesso.Profile profile) {
        PluginControladorDeAcesso.profile = (PluginProfile)profile;
    }

    protected ControladorDeAcesso.Profile getProfile() {
        return profile;
    }

    public boolean isExisteProfile() {
        boolean existe = false;
        try {
            ControladorDeAcesso.Profile profile = this.getProfile();
            existe = UtilObjeto.isReferencia(profile);
        }
        catch (Exception e) {
            this.getLog().warn(e);
        }
        return existe;
    }

    public void atualizaConvenente(ConvenenteTO convenenteTO) {
        this.getPluginProfile().setConvenenteTO(convenenteTO);
    }

    public void atualizaServico(String servico) {
        this.getPluginProfile().setServico(servico);
    }

    public ConvenenteTO getConvenenteTO() {
        return this.getPluginProfile().getConvenenteTO();
    }

    public String getTextoAcesso() {
        return this.getUsuarioTO() == null ? "" : this.getUsuarioTO().getTextoAcesso();
    }

    public String getTextoNome() {
        return this.getUsuarioTO() == null ? "" : this.getUsuarioTO().getTextoNome();
    }

    public String getServico() {
        return this.getPluginProfile() == null ? null : this.getPluginProfile().getServico();
    }

    public String getTextoNomeUsuarioSistema() {
        return this.getUsuarioTO().getTextoNomeUsuarioSistema();
    }

    public Integer getNumeroIdentificadorUsuario() {
        return this.getUsuarioTO() == null ? 0 : this.getUsuarioTO().getNumeroIdentificadorUsuario();
    }

    public String getTextoSenha() {
        return this.getUsuarioTO() == null ? "" : this.getUsuarioTO().getTextoSenha();
    }

    public PluginProfile getPluginProfile() {
        return (PluginProfile)this.getProfile();
    }

    protected UsuarioTO getUsuarioTO() {
        return this.getPluginProfile() == null ? null : this.getPluginProfile().getUsuarioTO();
    }

    protected FabricaDeControladorDeAcesso getFabricaDeControladorDeAcesso() {
        return FabricaDeControladorDeAcesso.getInstancia();
    }

    public Transacao novaTransacao(String caminhoMdb) {
        ServiceLocator serviceLocator = this.getFabricaDeServiceLocator().novoServiceLocator();
        Transacao transacao = this.getTransacaoFactory().novaTransacaoJDBC(serviceLocator.getConnection(caminhoMdb));
        return transacao;
    }

    public Transacao iniciarTransacao(String caminhoMdb) {
        Transacao transacao = null;
        if (!UtilObjeto.isReferencia(this.getTransacao())) {
            transacao = this.novaTransacao(caminhoMdb);
            this.getPluginProfile().setTransacao(transacao);
        }
        return transacao;
    }

    public FabricaDeServiceLocator getFabricaDeServiceLocator() {
        return FabricaDeServiceLocator.getInstancia();
    }

    public Transacao getTransacao(String caminhoMdb) {
        if (!UtilObjeto.isReferencia(this.getPluginProfile().getTransacao())) {
            Transacao transacao = this.novaTransacao(caminhoMdb);
            this.getPluginProfile().setTransacao(transacao);
        }
        return this.getPluginProfile().getTransacao();
    }

    protected Transacao novaTransacao() throws InfraRuntimeException {
        return null;
    }

    public boolean isTemAcesso(String textoIdentificadorServico, String textoCodigoOpcaoMenu, String transacao) {
        VerificarPermissaoFacade facade = FacadeFactory.getInstancia().novoVerificarPermissaoFacade();
        return facade.verificarAcesso(this.getUsuarioTO(), textoIdentificadorServico, textoCodigoOpcaoMenu, transacao);
    }

    public void setConvenenteTO(ConvenenteTO convenenteTO) {
        this.getPluginProfile().setConvenenteTO(convenenteTO);
    }

    public class PluginProfile
    extends ControladorDeAcesso.Profile {
        private UsuarioTO usuarioTO;
        private ConvenenteTO convenenteTO;
        private Transacao transacao;
        private String servico;

        public PluginProfile() {
            super(PluginControladorDeAcesso.this);
            this.servico = "!";
        }

        private String getServico() {
            return this.servico;
        }

        private void setServico(String servico) {
            this.servico = servico;
        }

        private UsuarioTO getUsuarioTO() {
            return this.usuarioTO;
        }

        private void setUsuarioTO(UsuarioTO usuarioTO) {
            this.usuarioTO = usuarioTO;
        }

        private ConvenenteTO getConvenenteTO() {
            return this.convenenteTO;
        }

        private void setConvenenteTO(ConvenenteTO convenenteTO) {
            this.convenenteTO = convenenteTO;
        }

        public Transacao getTransacao() {
            return this.transacao;
        }

        public void setTransacao(Transacao transacao) {
            this.transacao = transacao;
        }

        public boolean EUsuarioAdministrador() {
            if (this.getUsuarioTO() != null && this.getUsuarioTO().getGrupoUsuarioTO() != null) {
                VerificarPermissaoFacade facade = FacadeFactory.getInstancia().novoVerificarPermissaoFacade();
                return facade.EUsuarioAdministrador(this.getUsuarioTO());
            }
            return false;
        }
    }
}

