/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing;

import br.com.bb.plugins.gac.util.swing.ComponentTitledBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BBJBordaOval
implements Border {
    protected int m_w = 6;
    protected int m_h = 6;
    protected Color m_topColor = Color.white;
    protected Color m_bottomColor = Color.gray;
    private boolean bordertop = true;
    private boolean borderbottom = true;
    private boolean borderleft = true;
    private boolean borderright = true;
    private int linewidth = 1;
    private int bordertopwidth = 1;
    private int borderleftwidth = 1;
    private String titulo;
    private StringBuffer pedaco1;
    private StringBuffer pedaco2;
    private int palavras = 1;

    public int getPalavras() {
        return this.palavras;
    }

    public void setPalavras(int palavras) {
        this.palavras = palavras;
    }

    private BBJBordaOval() {
        this("");
    }

    private BBJBordaOval(String titulo) {
        this(titulo, 6, 6);
    }

    private BBJBordaOval(String titulo, int w, int h) {
        this(titulo, w, h, Color.GRAY, Color.GRAY);
    }

    private BBJBordaOval(String titulo, int w, int h, Color topColor, Color bottomColor) {
        this(titulo, w, h, topColor, bottomColor, true, true);
    }

    private BBJBordaOval(String titulo, int w, int h, Color topColor, Color bottomColor, boolean bordertop, boolean borderbottom) {
        this(titulo, w, h, topColor, bottomColor, true, true, true, true);
    }

    private BBJBordaOval(String titulo, int w, int h, Color topColor, Color bottomColor, boolean bordertop, boolean borderbottom, boolean borderleft, boolean borderright) {
        this(titulo, w, h, topColor, bottomColor, true, true, true, true, 1);
    }

    private BBJBordaOval(String titulo, int w, int h, Color topColor, Color bottomColor, boolean bordertop, boolean borderbottom, boolean borderleft, boolean borderright, int linewidth) {
        this(titulo, w, h, topColor, bottomColor, bordertop, borderbottom, borderleft, borderright, linewidth, 20, 12);
    }

    private BBJBordaOval(String titulo, int w, int h, Color topColor, Color bottomColor, boolean bordertop, boolean borderbottom, boolean borderleft, boolean borderright, int linewidth, int bordertopwidth, int borderleftwidth) {
        this.m_w = w;
        this.m_h = h;
        this.m_topColor = topColor;
        this.m_bottomColor = bottomColor;
        this.bordertop = bordertop;
        this.borderbottom = borderbottom;
        this.borderleft = borderleft;
        this.borderright = borderright;
        this.titulo = titulo;
        this.linewidth = linewidth;
        this.bordertopwidth = bordertopwidth;
        this.borderleftwidth = borderleftwidth;
        this.SplitTexto();
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.m_h, this.m_w, this.m_h, this.m_w);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        int icnt;
        --w;
        --h;
        g.setColor(this.m_topColor);
        if (this.borderleft) {
            icnt = 0;
            while (icnt < this.linewidth) {
                g.drawLine(x + icnt, y + h - (this.borderbottom ? this.m_h : 0), x + icnt, y + (this.bordertop ? this.m_h : 0));
                ++icnt;
            }
        }
        if (this.bordertop) {
            if (this.borderright) {
                icnt = 0;
                while (icnt < this.linewidth) {
                    g.drawArc(x + icnt, y + icnt, 2 * this.m_w, 2 * this.m_h, 180, -90);
                    ++icnt;
                }
            }
            if (this.borderleft) {
                icnt = 0;
                while (icnt < this.linewidth) {
                    g.drawArc(x + w - 2 * this.m_w - icnt, y + icnt, 2 * this.m_w, 2 * this.m_h, 90, -90);
                    ++icnt;
                }
            }
        }
        g.setFont(new Font("Arial", 0, 14));
        FontRenderContext frc = new FontRenderContext(null, true, false);
        int textlength = 0;
        if (this.titulo != null && this.titulo.length() > 0) {
            Rectangle2D bounds = g.getFont().getStringBounds(this.titulo, frc);
            textlength = (int)bounds.getWidth() + 8;
        }
        int icnt2 = 0;
        while (icnt2 < this.linewidth) {
            g.drawLine(this.borderleftwidth + textlength - 5, y + icnt2, x + w - (this.bordertop ? this.m_h : 0), y + icnt2);
            ++icnt2;
        }
        g.setColor(this.m_bottomColor);
        if (this.titulo != null && this.titulo.length() > 0) {
            this.DrawString(g, this.borderleftwidth, this.bordertopwidth, this.pedaco1, this.pedaco2);
            g.setColor(this.m_topColor);
        }
        if (this.borderright) {
            icnt2 = 0;
            while (icnt2 < this.linewidth) {
                g.drawLine(x + w - icnt2, y + (this.bordertop ? this.m_h : 0), x + w - icnt2, y + h - (this.borderbottom ? this.m_h : 0));
                ++icnt2;
            }
        }
        if (this.borderbottom) {
            if (this.borderright) {
                icnt2 = 0;
                while (icnt2 < this.linewidth) {
                    g.drawArc(x + w - 2 * this.m_w - icnt2, y + h - 2 * this.m_h - icnt2, 2 * this.m_w, 2 * this.m_h, 0, -90);
                    ++icnt2;
                }
            }
            if (this.borderleft) {
                icnt2 = 0;
                while (icnt2 < this.linewidth) {
                    g.drawArc(x + icnt2, y + h - 2 * this.m_h - icnt2, 2 * this.m_w, 2 * this.m_h, -90, -90);
                    ++icnt2;
                }
            }
        }
        icnt2 = 0;
        while (icnt2 < this.linewidth) {
            g.drawLine(x + (this.borderbottom ? this.m_h : 0), y + h - icnt2, x + w - (this.borderbottom ? this.m_h : 0), y + h - icnt2);
            ++icnt2;
        }
    }

    private void DrawString(Graphics g, int iposx, int iposicy, StringBuffer stb1, StringBuffer stb2) {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        g.setColor(new Color(139, 157, 221));
        g.drawString(stb1.toString(), iposx, iposicy);
        g.setColor(new Color(32, 71, 164));
        g.drawString(stb1.toString(), iposx + 1, iposicy);
        Rectangle2D textBounds = g.getFont().getStringBounds(stb1.toString(), frc);
        int iwidth = (int)textBounds.getWidth();
        Rectangle2D SpaceBounds = g.getFont().getStringBounds(" ", frc);
        int iwidthSpace = (int)SpaceBounds.getWidth();
        g.setColor(new Color(139, 157, 221));
        g.drawString(stb2.toString(), iposx + iwidth + iwidthSpace, iposicy);
        g.setColor(new Color(32, 71, 164));
        g.drawString(stb2.toString(), iposx + iwidth + iwidthSpace + 1, iposicy);
    }

    private void SplitTexto() {
        if (this.titulo == null) {
            return;
        }
        this.pedaco1 = new StringBuffer();
        this.pedaco2 = new StringBuffer();
        Pattern p = Pattern.compile("[\\s]+");
        String[] result = p.split(this.titulo);
        int icnt = 0;
        while (icnt < result.length) {
            if (icnt < this.palavras) {
                if (this.pedaco1.toString().length() > 0) {
                    this.pedaco1.append(" ");
                }
                this.pedaco1.append(result[icnt]);
            } else {
                if (this.pedaco2.toString().length() > 0) {
                    this.pedaco2.append(" ");
                }
                this.pedaco2.append(result[icnt]);
            }
            ++icnt;
        }
    }

    public static Border createOvalBorder() {
        return BBJBordaOval.createOvalBorder("");
    }

    public static Border createOvalBorder(String titulo) {
        return BBJBordaOval.createOvalBorder(titulo, 0);
    }

    public static Border createOvalBorder(String titulo, int top) {
        return BBJBordaOval.createOvalBorder(titulo, top, 0);
    }

    public static Border createOvalBorder(String titulo, int top, int left) {
        return new CompoundBorder(BorderFactory.createEmptyBorder(top + 7, 5, 7, 5), new BBJBordaOval(titulo, 7, 7, new Color(225, 225, 225), new Color(225, 225, 225), true, true, true, true, 1, top + 10, 14 + left));
    }

    public static Border createCheckBoxOvalBorder(String titulo, JComponent component, JCheckBox checkBox) {
        checkBox.setBackground(Color.white);
        checkBox.setFocusPainted(false);
        ComponentTitledBorder componentBorder = new ComponentTitledBorder(checkBox, component, BBJBordaOval.createOvalBorder(titulo, 5, 15));
        return componentBorder;
    }
}

