/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class OvalBorder
implements Border {
    protected int m_w = 6;
    protected int m_h = 6;
    protected Color m_topColor = Color.white;
    protected Color m_bottomColor = Color.gray;
    private boolean bordertop = true;
    private boolean borderbottom = true;

    public OvalBorder() {
        this(6, 6);
    }

    public OvalBorder(int w, int h) {
        this(w, h, Color.GRAY, Color.GRAY);
    }

    public OvalBorder(int w, int h, Color topColor, Color bottomColor) {
        this(w, h, topColor, bottomColor, true, true);
    }

    public OvalBorder(int w, int h, Color topColor, Color bottomColor, boolean bordertop, boolean borderbottom) {
        this.m_w = w;
        this.m_h = h;
        this.m_topColor = topColor;
        this.m_bottomColor = bottomColor;
        this.bordertop = bordertop;
        this.borderbottom = borderbottom;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.m_h, this.m_w, this.m_h, this.m_w);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        --w;
        g.setColor(this.m_topColor);
        g.drawLine(x, y + --h - (this.borderbottom ? this.m_h : 0), x, y + (this.bordertop ? this.m_h : 0));
        if (this.bordertop) {
            g.drawArc(x, y, 2 * this.m_w, 2 * this.m_h, 180, -90);
            g.drawArc(x + w - 2 * this.m_w, y, 2 * this.m_w, 2 * this.m_h, 90, -90);
        }
        g.drawLine(x + (this.bordertop ? this.m_h : 0), y, x + w - (this.bordertop ? this.m_h : 0), y);
        g.setColor(this.m_bottomColor);
        g.drawLine(x + w, y + (this.bordertop ? this.m_h : 0), x + w, y + h - (this.borderbottom ? this.m_h : 0));
        if (this.borderbottom) {
            g.drawArc(x + w - 2 * this.m_w, y + h - 2 * this.m_h, 2 * this.m_w, 2 * this.m_h, 0, -90);
            g.drawArc(x, y + h - 2 * this.m_h, 2 * this.m_w, 2 * this.m_h, -90, -90);
        }
        g.drawLine(x + (this.borderbottom ? this.m_h : 0), y + h, x + w - (this.borderbottom ? this.m_h : 0), y + h);
    }
}

