/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class PatternColorFilter
extends RGBImageFilter {
    private String[] pattern;
    private static char[] patternChars = new char[]{'X', ' ', '.'};
    private static Color[] patternColours = new Color[]{new Color(140, 140, 140), new Color(0, true), new Color(0, true)};

    private PatternColorFilter(String[] pattern, char[] patternChars, Color[] patternColours) {
        this.pattern = pattern;
        PatternColorFilter.patternChars = patternChars;
        PatternColorFilter.patternColours = patternColours;
        this.canFilterIndexColorModel = true;
    }

    public static synchronized Image createImage(Component c, boolean transparent, String[] pattern, char[] patternChars, Color[] patternColours) {
        if (patternChars == null || patternColours == null || pattern == null) {
            return null;
        }
        if (patternChars.length != patternColours.length) {
            return null;
        }
        int width = 0;
        int height = pattern.length;
        int i = 0;
        while (i < pattern.length) {
            if (width == 0) {
                width = pattern[i].length();
            } else if (width != pattern[i].length()) {
                return null;
            }
            ++i;
        }
        BufferedImage image = new BufferedImage(width, height, transparent ? 2 : 1);
        FilteredImageSource fis = new FilteredImageSource(image.getSource(), new PatternColorFilter(pattern, patternChars, patternColours));
        return c.createImage(fis);
    }

    public static synchronized Image createImage(Component c, String[] pattern, Color nColor) {
        PatternColorFilter.patternColours[0] = nColor;
        return PatternColorFilter.createImage(c, true, pattern, patternChars, patternColours);
    }

    public int filterRGB(int x, int y, int rgb) {
        if (this.pattern != null) {
            char c = this.pattern[y].charAt(x);
            int i = 0;
            while (i < patternChars.length) {
                if (patternChars[i] == c) {
                    return patternColours[i].getRGB();
                }
                ++i;
            }
        }
        return rgb;
    }
}

