/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableHdrRenderer
implements TableCellRenderer {
    Icon iconAscendente = null;
    Icon iconDescendente = null;
    TableCellRenderer realRenderer;
    JPanel panel;
    JLabel iconLabelAsc = new JLabel(this.getIconAscendente());
    JLabel iconLabelDesc = new JLabel(this.getIconDescendente());
    JLabel iconLabelNull = new JLabel();
    boolean asc = false;
    boolean inicio = true;
    static Color cor = Color.BLACK;

    public TableHdrRenderer(TableCellRenderer r, boolean asc) {
        this.asc = asc;
        this.inicio = false;
        this.realRenderer = r;
        this.iconLabelAsc.setBorder(BorderFactory.createEmptyBorder());
        this.iconLabelDesc.setBorder(BorderFactory.createEmptyBorder());
        this.iconLabelNull.setBorder(BorderFactory.createEmptyBorder());
    }

    public TableHdrRenderer(TableCellRenderer r) {
        this.asc = false;
        this.inicio = true;
        this.realRenderer = r;
        this.iconLabelAsc.setBorder(BorderFactory.createEmptyBorder());
        this.iconLabelDesc.setBorder(BorderFactory.createEmptyBorder());
        this.iconLabelNull.setBorder(BorderFactory.createEmptyBorder());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component c = this.realRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        TableColumn column = table.getColumnModel().getColumn(col);
        this.trataColHdr(c);
        return this.panel;
    }

    private void trataColHdr(Component c) {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.setBorder(BorderFactory.createBevelBorder(0));
            this.panel.add(c, "Center");
            this.panel.setToolTipText("Clique para ordenar");
            if (this.asc) {
                this.panel.add((Component)this.iconLabelAsc, "West");
            } else {
                this.panel.add((Component)this.iconLabelDesc, "West");
            }
            if (this.inicio) {
                this.panel.add((Component)this.iconLabelNull, "West");
            }
        }
        c.setFont(new Font("Dialog", 1, 12));
        c.setBackground(this.panel.getBackground());
        if (c instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)c;
            dtcr.setHorizontalAlignment(0);
        }
    }

    private Icon getIconAscendente() {
        return new SortAscendenteIcon();
    }

    private Icon getIconDescendente() {
        return new SortDescendenteIcon();
    }

    private static class SortAscendenteIcon
    implements Icon {
        private SortAscendenteIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(4, 1, 0, 5);
            g.setColor(cor);
            g.drawLine(5, 1, 9, 5);
            g.drawLine(0, 5, 9, 5);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 6;
        }
    }

    private static class SortDescendenteIcon
    implements Icon {
        private SortDescendenteIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(0, 1, 9, 1);
            g.drawLine(0, 1, 4, 5);
            g.setColor(cor);
            g.drawLine(9, 1, 5, 5);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 6;
        }
    }
}

