/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJDayChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJMonthChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BBJCalendar
extends JPanel
implements PropertyChangeListener {
    private Calendar calendar;
    protected BBJDayChooser dayChooser = null;
    private boolean initialized = false;
    protected boolean weekOfYearVisible = true;
    protected Locale locale;
    protected BBJMonthChooser monthChooser = null;
    private JPanel monthYearPanel;
    protected BBJYearChooser yearChooser = null;

    public BBJCalendar() {
        this(null, null, true, true);
    }

    public BBJCalendar(boolean monthSpinner) {
        this(null, null, monthSpinner, true);
    }

    public BBJCalendar(Date date) {
        this(date, null, true, true);
    }

    public BBJCalendar(Locale locale) {
        this(null, locale, true, true);
    }

    public BBJCalendar(Date date, Locale locale) {
        this(date, locale, true, true);
    }

    public BBJCalendar(Date date, boolean monthSpinner) {
        this(date, null, monthSpinner, true);
    }

    public BBJCalendar(Locale locale, boolean monthSpinner) {
        this(null, locale, monthSpinner, true);
    }

    public BBJCalendar(Date date, Locale locale, boolean monthSpinner, boolean weekOfYearVisible) {
        this.weekOfYearVisible = weekOfYearVisible;
        this.locale = locale;
        if (locale == null) {
            this.locale = Locale.getDefault();
        }
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        this.monthYearPanel = new JPanel();
        this.monthYearPanel.setLayout(new BorderLayout());
        this.monthChooser = new BBJMonthChooser(monthSpinner);
        this.yearChooser = new BBJYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        this.monthYearPanel.add((Component)this.monthChooser, "West");
        this.monthYearPanel.add((Component)this.yearChooser, "Center");
        this.monthYearPanel.setBorder(BorderFactory.createEmptyBorder());
        this.dayChooser = new BBJDayChooser(weekOfYearVisible);
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)this.monthYearPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.setBackground(Color.WHITE);
        this.initialized = true;
        this.setCalendar(this.calendar);
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JCalendar");
        frame.getContentPane().add(new BBJCalendar());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public BBJDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public BBJMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public String getName() {
        return "JCalendar";
    }

    public BBJYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public boolean isWeekOfYearVisible() {
        return this.dayChooser.isWeekOfYearVisible();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("month")) {
                c.set(2, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("year")) {
                c.set(1, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("date")) {
                c.setTime((Date)evt.getNewValue());
                this.setCalendar(c, true);
            }
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(bg);
        }
    }

    public void setCalendar(Calendar c) {
        this.setCalendar(c, true);
    }

    private void setCalendar(Calendar c, boolean update) {
        Calendar oldCalendar = this.calendar;
        this.calendar = c;
        if (update) {
            this.yearChooser.setYear(c.get(1));
            this.monthChooser.setMonth(c.get(2));
            this.dayChooser.setDay(c.get(5));
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(enabled);
            this.monthChooser.setEnabled(enabled);
            this.yearChooser.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(fg);
            this.monthChooser.setForeground(fg);
            this.yearChooser.setForeground(fg);
        }
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this.locale;
            this.locale = l;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", oldLocale, this.locale);
        }
    }

    public void setWeekOfYearVisible(boolean weekOfYearVisible) {
        this.dayChooser.setWeekOfYearVisible(weekOfYearVisible);
        this.setLocale(this.locale);
    }

    public boolean isDecorationBackgroundVisible() {
        return this.dayChooser.isDecorationBackgroundVisible();
    }

    public void setDecorationBackgroundVisible(boolean decorationBackgroundVisible) {
        this.dayChooser.setDecorationBackgroundVisible(decorationBackgroundVisible);
        this.setLocale(this.locale);
    }

    public boolean isDecorationBordersVisible() {
        return this.dayChooser.isDecorationBordersVisible();
    }

    public void setDecorationBordersVisible(boolean decorationBordersVisible) {
        this.dayChooser.setDecorationBordersVisible(decorationBordersVisible);
        this.setLocale(this.locale);
    }

    public Color getDecorationBackgroundColor() {
        return this.dayChooser.getDecorationBackgroundColor();
    }

    public void setDecorationBackgroundColor(Color decorationBackgroundColor) {
        this.dayChooser.setDecorationBackgroundColor(decorationBackgroundColor);
    }

    public Color getSundayForeground() {
        return this.dayChooser.getSundayForeground();
    }

    public Color getWeekdayForeground() {
        return this.dayChooser.getWeekdayForeground();
    }

    public void setSundayForeground(Color sundayForeground) {
        this.dayChooser.setSundayForeground(sundayForeground);
    }

    public void setWeekdayForeground(Color weekdayForeground) {
        this.dayChooser.setWeekdayForeground(weekdayForeground);
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public void setDate(Date date) {
        Date oldDate = this.calendar.getTime();
        this.calendar.setTime(date);
        this.yearChooser.setYear(this.calendar.get(1));
        this.monthChooser.setMonth(this.calendar.get(2));
        this.dayChooser.setDay(this.calendar.get(5));
        this.firePropertyChange("date", oldDate, date);
    }
}

