/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.PropertyList;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJCheckBoxList<T>
extends JPanel {
    private T[] opcoesLista;
    private JScrollPane scroll = new JScrollPane();
    private boolean zebrado = true;
    private ActionListener actionListener;
    private CheckBoxItem selectedCheck = null;
    private T selected;

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public BBJCheckBoxList() {
        this.zebrado = true;
        this.scroll.add(this);
        this.scroll.setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
    }

    public BBJCheckBoxList(T[] opcoes) {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.carregaLista(opcoes);
        this.scroll.add(this);
        this.scroll.setOpaque(false);
        this.zebrado = true;
    }

    public void carregaLista(T[] opcoes) {
        this.opcoesLista = opcoes;
        this.selected = null;
        this.selectedCheck = null;
        this.removeAll();
        int icnt = 0;
        while (icnt < this.opcoesLista.length) {
            PropertyList propertyList = (PropertyList)opcoes[icnt];
            if (propertyList.isCheckbox()) {
                CheckBoxItem check = new CheckBoxItem(opcoes[icnt]);
                this.add(Box.createRigidArea(new Dimension(5, 0)));
                this.add(check);
            } else {
                BBJLabel label = new BBJLabel(propertyList.getDescricao());
                this.add(Box.createRigidArea(new Dimension(2, 10)));
                this.add(label);
            }
            ++icnt;
        }
        this.updateUI();
        this.validate();
    }

    public T getSelected() {
        return this.selected;
    }

    public void selecionarObjeto(CheckBoxItem selectedCheck) {
        if (this.selectedCheck != null && this.selectedCheck != selectedCheck) {
            this.selectedCheck.setSelected(false);
        }
        if (selectedCheck.isSelected()) {
            this.selected = selectedCheck.getPropertyList();
            this.selectedCheck = selectedCheck;
            this.repaint();
        } else {
            this.selected = null;
            this.selectedCheck = null;
        }
        this.fireAction("SELECIONOU");
    }

    public boolean isZebrado() {
        return this.zebrado;
    }

    public void setZebrado(boolean zebrado) {
        this.zebrado = zebrado;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.actionListener != null && event != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    public int tamanhoDaLista() {
        return this.opcoesLista.length;
    }

    public int getIndexByKey(BBJTextLabel texto) {
        return 0;
    }

    public void deselectAllRows() {
    }

    public void selectRow(int i) {
    }

    public String[] getRow(int i) {
        return null;
    }

    public void makeRowVisible(int localizacao) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckBoxItem
    extends JCheckBox
    implements ActionListener {
        private T propertyList;

        public CheckBoxItem(T propertyList) {
            super(propertyList.toString());
            this.propertyList = null;
            this.propertyList = propertyList;
            this.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.setForeground(BBJEstilos.LABELTEXTO.getColor());
            this.setFocusable(true);
            this.setOpaque(false);
            this.addActionListener(this);
        }

        public T getPropertyList() {
            return this.propertyList;
        }

        public void setPropertyList(T propertyList) {
            this.propertyList = propertyList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BBJCheckBoxList.this.selecionarObjeto(this);
        }
    }
}

