/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.util.swing.IAcao;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboAutoSugestao<T>
extends JPanel
implements IAcao,
ItemSelectable {
    private static final long serialVersionUID = 1L;
    private JList list;
    private JScrollPane listScrollPane;
    private JButton buttonAbrirCombo;
    private JTextField textValor;
    private JPanel panel1;
    private int indice;
    private DefaultListModel listModel;
    private Collection<T> collectionLista = new ArrayList<T>();
    private Map<String, T> mapListaOriginal = new HashMap<String, T>();
    private String[] arrayListaOriginal;
    private boolean valorListaSelecinado;
    private GridBagConstraints gb1;
    private GridBagConstraints gb2;
    private boolean valorComCodigo;
    private int largura;
    private boolean isEditavel = true;
    private JFrame frameList;
    private boolean ajusteIndiceLista;
    private BBJComboAutoSugestaoMouseListener mouseListener;
    private int XcoordenadaList;
    private int YcoordenadaList;
    private int widthList;
    private int heightList;
    private PluginActionAbstrato acao;

    public BBJComboAutoSugestao() {
        this.init();
    }

    public BBJComboAutoSugestao(Collection<T> valores) {
        this.collectionLista = valores;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.panel1 = new JPanel();
        this.panel1.setAlignmentY(0.0f);
        this.panel1.setAlignmentX(0.0f);
        this.panel1.setLayout(new GridBagLayout());
        this.panel1.setBackground(Color.WHITE);
        this.gb1 = new GridBagConstraints();
        this.gb1.ipadx = this.largura == 0 ? this.getWidth() : this.largura;
        this.gb1.gridx = 0;
        this.gb1.gridy = 0;
        this.gb1.insets = new Insets(-1, -1, -1, -1);
        this.panel1.add((Component)this.getTextValor(), this.gb1);
        this.gb2 = new GridBagConstraints();
        this.gb2.ipadx = 5;
        this.gb2.ipady = 3;
        this.gb2.anchor = 17;
        this.gb2.gridx = 1;
        this.gb2.gridy = 0;
        this.gb2.insets = new Insets(-1, -1, -1, 0);
        this.panel1.add((Component)this.getButtonAbrirCombo(), this.gb2);
        this.add(this.panel1);
        this.setEnabled(this.isEditavel);
        this.inicializarLista();
        this.repaint();
    }

    private void alterarSelecionado() {
        this.indice = this.list.getSelectedIndex();
        this.setValorListaSelecinado(true);
        String selectedItem = this.removerCaracteresNegrigo(this.list.getSelectedValue().toString());
        this.getTextValor().setText(selectedItem);
        this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
    }

    public BBJComboAutoSugestao(Collection<T> lista, boolean editavel, int largura) {
        this.collectionLista = lista;
        this.isEditavel = editavel;
        this.largura = largura;
        this.init();
    }

    private void atualizarLista() {
        String valor = this.textValor.getText();
        if (valor.length() == 0 || this.isValorListaSelecinado()) {
            this.carregarLista(this.arrayListaOriginal);
            this.setValorListaSelecinado(false);
            return;
        }
        if (!this.isAjusteIndiceLista()) {
            this.abrirLista();
        }
        this.listModel = (DefaultListModel)this.list.getModel();
        Vector<String> vContains = new Vector<String>();
        String valorSemCodigo = null;
        this.setListModel(new DefaultListModel());
        int i = 0;
        while (i < this.arrayListaOriginal.length) {
            String linhaCombo = this.arrayListaOriginal[i];
            if (linhaCombo.startsWith(valor)) {
                linhaCombo = linhaCombo.replace(valor, "<b>" + valor + "</b>");
                this.getListModel().addElement("<html>" + linhaCombo + "</html>");
            } else {
                valorSemCodigo = linhaCombo.substring(this.getPosicaoIniciaLetras(linhaCombo));
                if (valorSemCodigo.startsWith(valor)) {
                    linhaCombo = linhaCombo.replace(valor, "<b>" + valor + "</b>");
                    this.getListModel().addElement("<html>" + linhaCombo + "</html>");
                } else if (linhaCombo.contains(valor)) {
                    linhaCombo = linhaCombo.replace(valor, "<b>" + valor + "</b>");
                    vContains.add("<html>" + linhaCombo + "</html>");
                }
            }
            ++i;
        }
        for (String sContains : vContains) {
            this.getListModel().addElement(sContains);
        }
        this.getList().setModel(this.getListModel());
    }

    private void carregarLista(Object[] lista) {
        if (lista == null || lista.length == 0) {
            return;
        }
        this.listModel = new DefaultListModel();
        int i = 0;
        while (i < lista.length) {
            String valor = (String)lista[i];
            this.listModel.addElement(valor);
            ++i;
        }
        this.getList().setModel(this.listModel);
    }

    private void inicializarLista() {
        this.listModel = new DefaultListModel();
        this.arrayListaOriginal = new String[this.collectionLista.size()];
        Iterator<T> itr = this.collectionLista.iterator();
        int i = 0;
        while (itr.hasNext()) {
            T obj = itr.next();
            this.arrayListaOriginal[i] = obj.toString();
            this.mapListaOriginal.put(this.arrayListaOriginal[i], obj);
            this.listModel.addElement(this.arrayListaOriginal[i]);
            ++i;
        }
        this.getList().setModel(this.listModel);
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setFont(new Font(this.list.getFont().getName(), 0, this.list.getFont().getSize()));
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    if (!evt.getValueIsAdjusting() && !BBJComboAutoSugestao.this.isAjusteIndiceLista() && BBJComboAutoSugestao.this.list.getSelectedIndex() != -1) {
                        BBJComboAutoSugestao.this.alterarSelecionado();
                        BBJComboAutoSugestao.this.fecharLista();
                    }
                }
            });
            this.list.setVisibleRowCount(5);
        }
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane(this.getList());
            this.listScrollPane.getViewport().setBackground(Color.WHITE);
        }
        return this.listScrollPane;
    }

    public void setListScrollPane(JScrollPane listScrollPane) {
        this.listScrollPane = listScrollPane;
    }

    public JButton getButtonAbrirCombo() {
        if (this.buttonAbrirCombo == null) {
            this.buttonAbrirCombo = new BasicArrowButton(5, Color.WHITE, Color.BLACK, Color.BLACK, Color.BLACK);
            this.buttonAbrirCombo.setPreferredSize(new Dimension(21, 18));
            this.buttonAbrirCombo.setMinimumSize(new Dimension(21, 18));
            this.buttonAbrirCombo.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.buttonAbrirCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                        BBJComboAutoSugestao.this.fecharLista();
                    } else {
                        BBJComboAutoSugestao.this.getTextValor().requestFocus();
                        BBJComboAutoSugestao.this.abrirLista();
                    }
                }
            });
        }
        return this.buttonAbrirCombo;
    }

    public void setButtonAbrirCombo(JButton buttonAbrirCombo) {
        this.buttonAbrirCombo = buttonAbrirCombo;
    }

    public JTextField getTextValor() {
        if (this.textValor == null) {
            this.textValor = new JTextField();
            this.textValor.setHorizontalAlignment(2);
            AbstractDocument document = (AbstractDocument)this.textValor.getDocument();
            document.setDocumentFilter(new UppercaseDocumentFilter());
            this.textValor.addKeyListener(new BBJComboAutoSugestaoKeyListener());
            this.textValor.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (BBJComboAutoSugestao.this.frameList != null && BBJComboAutoSugestao.this.frameList.isVisible()) {
                        if (BBJComboAutoSugestao.this.getList().getSelectedIndex() != -1) {
                            BBJComboAutoSugestao.this.alterarSelecionado();
                        }
                        BBJComboAutoSugestao.this.fecharLista();
                        BBJComboAutoSugestao.this.setAjusteIndiceLista(false);
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.textValor.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent arg0) {
                    if (!BBJComboAutoSugestao.this.isValorListaSelecinado()) {
                        BBJComboAutoSugestao.this.atualizarLista();
                    }
                }

                public void insertUpdate(DocumentEvent arg0) {
                    BBJComboAutoSugestao.this.atualizarLista();
                }

                public void changedUpdate(DocumentEvent arg0) {
                    BBJComboAutoSugestao.this.atualizarLista();
                }
            });
        }
        return this.textValor;
    }

    public JPanel getPanel1() {
        return this.panel1;
    }

    public void setPanel1(JPanel panel1) {
        this.panel1 = panel1;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(DefaultListModel listModel) {
        this.listModel = listModel;
    }

    public String[] getArrayListaListaOriginal() {
        return this.arrayListaOriginal;
    }

    public void setListaOriginal(String[] listaOriginal) {
        this.arrayListaOriginal = listaOriginal;
    }

    public int getPosicaoIniciaLetras(String linha) {
        int i = 0;
        while (i < linha.length()) {
            String letra = "" + linha.charAt(i);
            if (letra.matches("^[a-zA-Z]*$")) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public boolean isValorListaSelecinado() {
        return this.valorListaSelecinado;
    }

    public void setValorListaSelecinado(boolean valorAlterado) {
        this.valorListaSelecinado = valorAlterado;
    }

    private String removerCaracteresNegrigo(String selecionado) {
        return selecionado.replace("<html>", "").replace("</html>", "").replace("</b>", "").replace("<b>", "");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTextValor().setEnabled(enabled);
        this.getButtonAbrirCombo().setEnabled(enabled);
        if (this.frameList != null) {
            this.fecharLista();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (this.frameList != null) {
            this.fecharLista();
        }
    }

    public boolean isValorComCodigo() {
        return this.valorComCodigo;
    }

    public void preencherCombo(Collection<T> lista) {
        this.collectionLista = lista;
        this.inicializarLista();
    }

    public void setValorComCodigo(boolean valorComCodigo) {
        this.valorComCodigo = valorComCodigo;
    }

    public T getSelectedItem() {
        if (!this.getTextValor().getText().equals("") && this.mapListaOriginal.containsKey(this.getTextValor().getText().trim())) {
            return this.mapListaOriginal.get(this.getTextValor().getText().trim());
        }
        return null;
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    public void setSelectedItem(T t) {
        if (t == null) {
            this.getTextValor().setText("");
            if (this.frameList != null && this.frameList.isVisible()) {
                this.fecharLista();
            }
            return;
        }
        this.setAjusteIndiceLista(true);
        this.getTextValor().setText(t.toString());
        this.carregarLista(this.arrayListaOriginal);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ItemListener.class) {
                ((ItemListener)listeners[i + 1]).itemStateChanged(e);
            }
            i -= 2;
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        T selectedObject = this.getSelectedItem();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public Collection<T> getCollectionLista() {
        return this.collectionLista;
    }

    public void setCollectionLista(Collection<T> collectionLista) {
        this.collectionLista = collectionLista;
    }

    public JFrame getFrameList() {
        if (this.frameList == null) {
            this.frameList = new JFrame();
            this.frameList.setDefaultCloseOperation(3);
            this.frameList.setUndecorated(true);
            this.frameList.setFocusableWindowState(false);
            JPanel panel = (JPanel)this.frameList.getContentPane();
            this.widthList = this.getTextValor().getWidth() + this.getButtonAbrirCombo().getWidth() + 1;
            this.heightList = 150;
            Point location = this.getTextValor().getLocationOnScreen();
            this.XcoordenadaList = location.x;
            this.YcoordenadaList = this.getTextValor().getHeight() + location.y - 1;
            panel.add((Component)this.getListScrollPane(), "Center");
            this.frameList.setPreferredSize(new Dimension(this.widthList, this.heightList));
            this.frameList.setBounds(this.XcoordenadaList, this.YcoordenadaList, this.widthList, this.heightList);
            this.frameList.pack();
            this.criarEventoMouse();
        }
        return this.frameList;
    }

    public boolean isAjusteIndiceLista() {
        return this.ajusteIndiceLista;
    }

    public void setAjusteIndiceLista(boolean ajusteIndiceListaComTeclado) {
        this.ajusteIndiceLista = ajusteIndiceListaComTeclado;
    }

    private void posicionaTextoNaLista() {
        if (!this.getTextValor().getText().equals("")) {
            this.setAjusteIndiceLista(true);
            if (this.getListModel().contains(this.getTextValor().getText())) {
                this.getList().setSelectedValue(this.getTextValor().getText().trim(), true);
            } else {
                this.getList().setSelectedIndex(0);
            }
            this.setAjusteIndiceLista(false);
        }
    }

    private void abrirLista() {
        if (!this.isEnabled()) {
            if (this.frameList != null && this.frameList.isVisible()) {
                this.fecharLista();
            }
            return;
        }
        this.reposicionarFrameList();
        this.getFrameList().setVisible(true);
        this.getFrameList().toFront();
        this.posicionaTextoNaLista();
    }

    private void fecharLista() {
        this.getFrameList().setVisible(false);
        this.setAjusteIndiceLista(false);
    }

    private void reposicionarFrameList() {
        if (!this.getTextValor().isShowing()) {
            return;
        }
        boolean alterou = false;
        if (this.getTextValor().getLocationOnScreen().x != this.getFrameList().getX()) {
            this.XcoordenadaList = this.getTextValor().getLocationOnScreen().x;
            alterou = true;
        }
        if (this.getTextValor().getLocationOnScreen().y + this.getTextValor().getHeight() - 1 != this.getFrameList().getY()) {
            this.YcoordenadaList = this.getTextValor().getLocationOnScreen().y + this.getTextValor().getHeight() - 1;
            alterou = true;
        }
        if (this.widthList != this.getTextValor().getWidth() + this.getButtonAbrirCombo().getWidth() - 1) {
            this.widthList = this.getTextValor().getWidth() + this.getButtonAbrirCombo().getWidth() - 1;
            alterou = true;
        }
        if (alterou) {
            this.frameList.setPreferredSize(new Dimension(this.widthList, this.heightList));
            this.getFrameList().setBounds(this.XcoordenadaList, this.YcoordenadaList, this.widthList, this.heightList);
            this.getFrameList().pack();
        }
    }

    private void criarEventoMouse() {
        if (this.mouseListener == null) {
            this.mouseListener = new BBJComboAutoSugestaoMouseListener();
            this.getTopLevelAncestor().addMouseListener(this.mouseListener);
            this.getFocusCycleRootAncestor().addMouseListener(this.mouseListener);
        }
    }

    @Override
    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.acao = acao;
    }

    public int getSelectedIndex() {
        return this.getList().getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.getList().setSelectedIndex(index);
    }

    class BBJComboAutoSugestaoKeyListener
    extends KeyAdapter {
        BBJComboAutoSugestaoKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (!BBJComboAutoSugestao.this.getTextValor().isShowing()) {
                return;
            }
            if (e.getKeyCode() == 40) {
                if (BBJComboAutoSugestao.this.getList().getSelectedIndex() == -1) {
                    BBJComboAutoSugestao.this.setAjusteIndiceLista(true);
                    if (BBJComboAutoSugestao.this.getTextValor().getText().equals("")) {
                        BBJComboAutoSugestao.this.getList().setSelectedIndex(0);
                    }
                    BBJComboAutoSugestao.this.abrirLista();
                } else if (BBJComboAutoSugestao.this.getList().getSelectedIndex() != BBJComboAutoSugestao.this.getList().getModel().getSize() - 1) {
                    BBJComboAutoSugestao.this.setAjusteIndiceLista(true);
                    BBJComboAutoSugestao.this.getList().setSelectedIndex(BBJComboAutoSugestao.this.getList().getSelectedIndex() + 1);
                    BBJComboAutoSugestao.this.getList().ensureIndexIsVisible(BBJComboAutoSugestao.this.getList().getSelectedIndex());
                    if (!BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                        BBJComboAutoSugestao.this.abrirLista();
                    }
                }
            }
            if (e.getKeyCode() == 38) {
                if (BBJComboAutoSugestao.this.getList().getSelectedIndex() == -1) {
                    BBJComboAutoSugestao.this.setAjusteIndiceLista(true);
                    if (BBJComboAutoSugestao.this.getTextValor().getText().equals("")) {
                        BBJComboAutoSugestao.this.getList().setSelectedIndex(BBJComboAutoSugestao.this.getList().getModel().getSize() - 1);
                        BBJComboAutoSugestao.this.getList().ensureIndexIsVisible(BBJComboAutoSugestao.this.getList().getSelectedIndex());
                        BBJComboAutoSugestao.this.posicionaTextoNaLista();
                    }
                    BBJComboAutoSugestao.this.abrirLista();
                } else if (BBJComboAutoSugestao.this.getList().getSelectedIndex() != 0) {
                    BBJComboAutoSugestao.this.setAjusteIndiceLista(true);
                    BBJComboAutoSugestao.this.getList().setSelectedIndex(BBJComboAutoSugestao.this.getList().getSelectedIndex() - 1);
                    BBJComboAutoSugestao.this.getList().ensureIndexIsVisible(BBJComboAutoSugestao.this.getList().getSelectedIndex());
                    if (!BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                        BBJComboAutoSugestao.this.abrirLista();
                    }
                }
            }
            if (BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                if ((e.getKeyCode() == 10 || e.getKeyCode() == 27 || e.getKeyCode() == 9) && BBJComboAutoSugestao.this.getList().getSelectedIndex() != -1) {
                    BBJComboAutoSugestao.this.alterarSelecionado();
                    BBJComboAutoSugestao.this.fecharLista();
                }
                if (e.getKeyCode() == 27 || e.getKeyCode() == 9) {
                    BBJComboAutoSugestao.this.fecharLista();
                }
            }
            BBJComboAutoSugestao.this.setAjusteIndiceLista(false);
        }
    }

    class BBJComboAutoSugestaoMouseListener
    extends MouseAdapter {
        boolean mouseForaCombo = false;

        BBJComboAutoSugestaoMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.mouseForaCombo && BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                BBJComboAutoSugestao.this.fecharLista();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.mouseForaCombo && BBJComboAutoSugestao.this.getFrameList().isVisible()) {
                BBJComboAutoSugestao.this.fecharLista();
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseForaCombo = true;
        }

        public void mouseExited(MouseEvent e) {
            this.mouseForaCombo = false;
        }
    }

    class UppercaseDocumentFilter
    extends DocumentFilter {
        UppercaseDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, text.toUpperCase(), attr);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            fb.replace(offset, length, text.toUpperCase(), attrs);
        }
    }
}

