/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboAutoSugestao;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.IComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboAutoSugestaoLabel<T>
extends JPanel
implements IAcao,
IComponent {
    private static final long serialVersionUID = 1L;
    private String titulo;
    private int posicaoLabel = 0;
    private int larguralabel;
    private int largura;
    private BBJLabel jlTitulo;
    private BBJComboAutoSugestao<T> combobox;
    private Map<String, T> opcoesCombo;
    private int maxChars = 50;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilolabel;
    private boolean isEditavel;
    private boolean isHabilitado;
    private PluginActionAbstrato acao;
    private String toolTip = "";
    private Collection<T> lista = new ArrayList<T>();

    public BBJComboAutoSugestaoLabel(String titulo, int posicaoLabel, Map<String, T> opcoesCombo) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.initialize();
    }

    public BBJComboAutoSugestaoLabel(String titulo, boolean editavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.isEditavel = editavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJComboAutoSugestaoLabel(Collection<T> lista, String titulo, boolean editavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.isEditavel = editavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.lista = lista;
        this.initialize();
    }

    public void preencherCombo(Collection<T> lista) {
        this.getJcbCombo().preencherCombo(lista);
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<T> lista) {
        return new DefaultComboBoxModel<Object>(lista.toArray());
    }

    public BBJComboAutoSugestaoLabel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.isEditavel = isEditavel;
        this.initialize();
    }

    public BBJComboAutoSugestaoLabel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int larguralabel) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.isEditavel = isEditavel;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJComboAutoSugestaoLabel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int largura, int larguralabel) {
        this(titulo, isEditavel, posicaoLabel, opcoesCombo, largura, larguralabel, 50);
    }

    public BBJComboAutoSugestaoLabel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int largura, int larguralabel, int maxChars) {
        this.titulo = titulo;
        this.isEditavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.maxChars = maxChars;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.setComboBox(new BBJComboAutoSugestao<T>(this.lista, this.isEditavel, this.largura));
        this.getComboBox().setEnabled(this.isEditavel);
        this.getComboBox().setOpaque(false);
        this.getComboBox().setFont(this.estilotexto.getFont());
        this.getComboBox().setForeground(this.estilotexto.getColor());
        this.getComboBox().setBackground(this.estilotexto.getBackcolor());
        this.getComboBox().setEnabled(this.isEditavel());
        this.jlTitulo = new BBJLabel(" ");
        this.jlTitulo.setFont(this.estilolabel.getFont());
        this.jlTitulo.setForeground(this.estilolabel.getColor());
        this.jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            this.jlTitulo.setText(this.titulo);
        }
        this.add(this.jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.getComboBox());
        if (this.opcoesCombo != null) {
            this.loadCombo(this.opcoesCombo);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.getComboBox().getHeight() + 5);
            g.drawString(this.titulo, 2, posiy);
        }
    }

    public void loadCombo(Map<String, T> opcoesCombo) {
        Iterator<T> itr = opcoesCombo.values().iterator();
        this.opcoesCombo = opcoesCombo;
        while (itr.hasNext()) {
            T t = itr.next();
        }
        this.getJcbCombo().updateUI();
    }

    public void loadCombo(Collection<T> opcoes) {
        for (T t : opcoes) {
        }
        this.getJcbCombo().updateUI();
    }

    public T getSelectedItem() {
        return this.getJcbCombo().getSelectedItem();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getJcbCombo().setEnabled(enabled);
        this.getComboBox().setToolTipText(enabled ? this.toolTip : null);
    }

    public void setSelectedItem(T obj) {
        this.getComboBox().setSelectedItem(obj);
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    @Override
    public void setTitulo(String titulo) {
        this.titulo = titulo;
        if (this.posicaoLabel == 0) {
            this.jlTitulo.setText(this.titulo);
        }
        this.repaint();
    }

    public Map<String, T> getOpcoesCombo() {
        return this.opcoesCombo;
    }

    public void setOpcoesCombo(Map<String, T> opcoesCombo) {
        this.opcoesCombo = opcoesCombo;
    }

    public BBJComboAutoSugestao getJcbCombo() {
        return this.getComboBox();
    }

    public BBJLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(BBJLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public boolean isEditavel() {
        return this.isEditavel;
    }

    public void setHabilitado(boolean b) {
        this.isHabilitado = b;
    }

    public boolean isHabilitado() {
        return this.isHabilitado;
    }

    public void setEditavel(boolean isEditavel) {
        this.getComboBox().setEnabled(isEditavel);
        this.getComboBox().setBackground(isEditavel ? this.estilotexto.getBackcolor() : BBJEstilos.TEXTONAOEDITAVEL.getBackcolor());
        this.getComboBox().setForeground(BBJEstilos.TEXTONAOEDITAVEL.getColor());
        this.isEditavel = isEditavel;
    }

    @Override
    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.acao = acao;
    }

    @Override
    public void setName(String name) {
        this.getJcbCombo().setName(name);
    }

    public void setPopupVisible(boolean b) {
    }

    public void setTexto(String texto) {
    }

    public BBJComboAutoSugestao<T> getComboBox() {
        if (this.combobox == null) {
            this.combobox = new BBJComboAutoSugestao();
        }
        return this.combobox;
    }

    public void setComboBox(BBJComboAutoSugestao<T> combobox) {
        this.combobox = combobox;
    }

    @Override
    public void requestFocus() {
        this.getComboBox().requestFocus();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.toolTip = text;
        if (this.jlTitulo != null) {
            this.jlTitulo.setToolTipText(text);
        }
        if (this.combobox != null) {
            this.combobox.setToolTipText(text);
        }
    }

    public void forcarTamanhoDaCombo(Dimension d) {
        this.getComboBox().setMinimumSize(new Dimension(170, 20));
        this.getComboBox().setMaximumSize(new Dimension(170, 20));
        this.getComboBox().setPreferredSize(new Dimension(170, 20));
    }

    @Override
    public String getTituloLabel() {
        return this.getJlTitulo().getText();
    }

    @Override
    public void setTituloLabel(String titulo) {
        this.getJlTitulo().setText(titulo);
    }

    public void addItemListener(ItemListener aListener) {
        this.getComboBox().addItemListener(aListener);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        this.getComboBox().fireItemStateChanged(e);
    }

    public Object[] getSelectedObjects() {
        return this.getComboBox().getSelectedObjects();
    }

    public void removeItemListener(ItemListener aListener) {
        this.getComboBox().removeItemListener(aListener);
    }

    public int getSelectedIndex() {
        return this.getComboBox().getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.getComboBox().setSelectedIndex(index);
    }
}

