/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJCalendar;
import br.com.bb.plugins.gac.util.swing.componente.BBJDate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class BBJDateChooserPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private BBJDate txtData = null;
    private JButton btnCalendario = null;
    private BBJCalendar calendar = null;
    private JPopupMenu popup = null;
    private Date dataAtual = null;
    private boolean dateSelected;
    private boolean showed = false;

    public BBJDateChooserPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(206, 21);
        this.setBackground(Color.WHITE);
        this.setMinimumSize(new Dimension(80, 21));
        this.setPreferredSize(new Dimension(80, 21));
        this.add((Component)this.getTxtData(), "Center");
        this.add((Component)this.getBtnCalendario(), "East");
        this.getBtnCalendario().addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.setShowed(true);
        int x = this.getBtnCalendario().getWidth() - (int)this.getPopup().getPreferredSize().getWidth();
        int y = this.getBtnCalendario().getY() + this.getBtnCalendario().getHeight();
        Calendar calendar = Calendar.getInstance();
        if (this.getTxtData().getDate() != null) {
            calendar.setTime(this.getTxtData().getDate());
        } else {
            calendar.setTime(this.getDataAtual());
        }
        this.getCalendar().setCalendar(calendar);
        this.getCalendar().getDayChooser().addPropertyChangeListener(this);
        this.getPopup().show(this.getBtnCalendario(), x, y);
        this.dateSelected = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.setShowed(false);
            this.setDate(this.getCalendar().getCalendar().getTime());
            this.getCalendar().getDayChooser().removePropertyChangeListener(this);
        } else if (evt.getPropertyName().equals("date")) {
            this.setDate((Date)evt.getNewValue());
            this.getCalendar().getDayChooser().removePropertyChangeListener(this);
        } else if (evt.getSource() == this.getPopup() && evt.getPropertyName().equals("visible") && evt.getNewValue().toString().equals("false")) {
            this.getPopup().setVisible(false);
        }
    }

    public BBJDate getTxtData() {
        if (this.txtData == null) {
            this.txtData = new BBJDate();
        }
        return this.txtData;
    }

    public JButton getBtnCalendario() {
        if (this.btnCalendario == null) {
            this.btnCalendario = new JButton();
            this.btnCalendario.setIcon(new ImageIcon(this.getClass().getResource("/images/JDateChooserColor16.gif")));
            this.btnCalendario.setMinimumSize(new Dimension(22, 21));
            this.btnCalendario.setMaximumSize(new Dimension(22, 21));
            this.btnCalendario.setPreferredSize(new Dimension(22, 21));
            this.btnCalendario.setFocusPainted(false);
            this.btnCalendario.setRequestFocusEnabled(false);
        }
        return this.btnCalendario;
    }

    private BBJCalendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = new BBJCalendar();
            this.calendar.getDayChooser().setAlwaysFireDayProperty(true);
            this.calendar.setWeekOfYearVisible(false);
        }
        return this.calendar;
    }

    private JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu(){

                public void setVisible(boolean b) {
                    Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                    if (b || !b && BBJDateChooserPanel.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                        super.setVisible(b);
                    }
                }
            };
            this.popup.setFocusable(false);
            this.popup.setLightWeightPopupEnabled(true);
            this.popup.add(this.getCalendar());
            this.popup.addPropertyChangeListener(this);
        }
        return this.popup;
    }

    private Date getDataAtual() {
        if (this.dataAtual == null) {
            this.dataAtual = new Date(System.currentTimeMillis());
        }
        return this.dataAtual;
    }

    public void setDate(Date dt) {
        if (dt == null) {
            this.clear();
        }
        this.getTxtData().setDate(dt);
    }

    public Date getDate() {
        return this.getTxtData().getDate();
    }

    public String getDateAsString() {
        return this.getTxtData().getText().trim();
    }

    public void setDate(String date) {
        this.getTxtData().setText(date);
    }

    public void clear() {
        this.getTxtData().setDate(null);
    }

    public void setEnabled(boolean b) {
        this.getTxtData().setEditable(b);
        this.getBtnCalendario().setEnabled(b);
    }

    public boolean isEnabled() {
        return this.getTxtData().isEditable();
    }

    public void requestFocus() {
        this.getTxtData().requestFocus();
    }

    public boolean isDataValida() {
        return this.getTxtData().getDate() != null || this.getTxtData().getText().equals("");
    }

    public boolean isShowed() {
        return this.showed;
    }

    public void setShowed(boolean b) {
        this.showed = b;
    }
}

