/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BBJDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    protected ButtonCal[] days;
    protected JButton[] weeks;
    protected JButton selectedDay;
    protected JPanel weekPanel;
    protected JPanel dayPanel;
    protected int day;
    protected Color oldDayBackgroundColor;
    protected Color selectedColor;
    protected Color sundayForeground;
    protected Color weekdayForeground;
    protected Color decorationBackgroundColor;
    protected String[] dayNames;
    protected Calendar calendar;
    protected Calendar today;
    protected Locale locale;
    protected boolean initialized;
    protected boolean weekOfYearVisible;
    protected boolean decorationBackgroundVisible = true;
    protected boolean decorationBordersVisible;
    private boolean alwaysFireDayProperty;

    public BBJDayChooser() {
        this(false);
        this.alwaysFireDayProperty = true;
    }

    public BBJDayChooser(boolean weekOfYearVisible) {
        this.setBackground(Color.WHITE);
        this.weekOfYearVisible = weekOfYearVisible;
        this.locale = Locale.getDefault();
        this.days = new ButtonCal[49];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)this.calendar.clone();
        this.setLayout(new BorderLayout());
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        this.dayPanel.setBackground(Color.WHITE);
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = new Color(0, 90, 164);
        this.decorationBackgroundColor = new Color(210, 228, 238);
        int y = 0;
        while (y < 7) {
            int x = 0;
            while (x < 7) {
                int index = x + 7 * y;
                if (y == 0) {
                    this.days[index] = new ButtonCal(this){

                        public void addMouseListener(MouseListener l) {
                        }

                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[index].setContentAreaFilled(this.decorationBackgroundVisible);
                    this.days[index].setBorderPainted(this.decorationBordersVisible);
                    this.days[index].setBackground(this.decorationBackgroundColor);
                } else {
                    this.days[index] = new ButtonCal("x");
                    this.days[index].addActionListener(this);
                    this.days[index].addKeyListener(this);
                    this.days[index].addFocusListener(this);
                }
                this.days[index].setMargin(new Insets(0, 0, 0, 0));
                this.days[index].setFocusPainted(false);
                this.days[index].setBackground(Color.WHITE);
                this.dayPanel.add(this.days[index]);
                ++x;
            }
            ++y;
        }
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridLayout(7, 1));
        this.weekPanel.setVisible(false);
        this.weeks = new JButton[7];
        int i = 0;
        while (i < 7) {
            this.weeks[i] = new JButton(){

                public void addMouseListener(MouseListener l) {
                }

                public boolean isFocusable() {
                    return false;
                }
            };
            this.weeks[i].setMargin(new Insets(0, 0, 0, 0));
            this.weeks[i].setFocusPainted(false);
            this.weeks[i].setBackground(Color.WHITE);
            this.weeks[i].setForeground(new Color(100, 100, 100));
            this.weeks[i].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[i].setBorderPainted(this.decorationBordersVisible);
            if (i != 0) {
                this.weeks[i].setText("0" + (i + 1));
            }
            this.weekPanel.setBackground(Color.WHITE);
            this.weeks[i].setBackground(Color.WHITE);
            this.weekPanel.add(this.weeks[i]);
            ++i;
        }
        this.init();
        this.drawWeeks();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)this.dayPanel, "Center");
        if (weekOfYearVisible) {
            this.add((Component)this.weekPanel, "West");
        }
        this.initialized = true;
    }

    protected void init() {
        JButton testButton = new JButton();
        this.oldDayBackgroundColor = new Color(239, 247, 254);
        this.selectedColor = new Color(219, 221, 223);
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setTime(date);
        this.drawDayNames();
        this.drawDays();
    }

    private void drawDayNames() {
        int firstDayOfWeek = 1;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        int i = 0;
        while (i < 7) {
            this.days[i].setText(this.dayNames[day]);
            this.days[i].setTitulo(true);
            if (day == 1) {
                this.days[i].setForeground(this.sundayForeground);
            } else {
                this.days[i].setForeground(this.weekdayForeground);
            }
            day = day < 7 ? ++day : (day -= 6);
            ++i;
        }
    }

    protected void initDecorations() {
        int x = 0;
        while (x < 7) {
            this.days[x].setContentAreaFilled(this.decorationBackgroundVisible);
            this.days[x].setBorderPainted(this.decorationBordersVisible);
            this.weeks[x].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[x].setBorderPainted(this.decorationBordersVisible);
            ++x;
        }
    }

    protected void drawWeeks() {
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        int i = 1;
        while (i < 7) {
            tmpCalendar.set(5, i * 7 - 6);
            int week = tmpCalendar.get(3);
            String buttonText = Integer.toString(week);
            if (week < 10) {
                buttonText = "0" + buttonText;
            }
            this.weeks[i].setText(buttonText);
            if (i == 5 || i == 6) {
                this.weeks[i].setVisible(this.days[i * 7].isVisible());
            }
            ++i;
        }
    }

    protected void drawDays() {
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        int firstDayOfWeek = 1;
        tmpCalendar.set(5, 1);
        int firstDay = tmpCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        int i = 0;
        while (i < firstDay) {
            this.days[i + 7].setVisible(false);
            this.days[i + 7].setText("");
            ++i;
        }
        tmpCalendar.add(2, 1);
        Date firstDayInNextMonth = tmpCalendar.getTime();
        tmpCalendar.add(2, -1);
        Date day = tmpCalendar.getTime();
        int n = 0;
        Color foregroundColor = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            this.days[i + n + 7].setText(Integer.toString(n + 1));
            this.days[i + n + 7].setVisible(true);
            if (tmpCalendar.get(6) == this.today.get(6) && tmpCalendar.get(1) == this.today.get(1) || tmpCalendar.get(7) == 1) {
                this.days[i + n + 7].setForeground(this.sundayForeground);
            } else {
                this.days[i + n + 7].setForeground(foregroundColor);
            }
            this.days[i + n + 7].setDomingo(tmpCalendar.get(7) == 1);
            if (n + 1 == this.day) {
                this.days[i + n + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[i + n + 7];
            } else {
                this.days[i + n + 7].setBackground(this.oldDayBackgroundColor);
            }
            if (tmpCalendar.get(6) == this.today.get(6) && tmpCalendar.get(1) == this.today.get(1)) {
                this.days[i + n + 7].setBackground(new Color(206, 219, 246));
                Font tempFont = new Font(this.days[i + n + 7].getFont().getName(), 1, this.days[i + n + 7].getFont().getSize());
                this.days[i + n + 7].setFont(tempFont);
            }
            ++n;
            tmpCalendar.add(5, 1);
            day = tmpCalendar.getTime();
        }
        int k = n + i + 7;
        while (k < 49) {
            this.days[k].setVisible(false);
            this.days[k].setText("");
            ++k;
        }
        int cnt = 7;
        while (cnt < 42) {
            if (this.days[cnt].isVisible()) {
                this.days[cnt].setUltimalinha(!this.days[cnt + 7].isVisible());
                this.days[cnt].setUltimacoluna((cnt + 1) % 7 == 0 || !this.days[cnt + 1].isVisible());
            }
            ++cnt;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            super.setLocale(locale);
            this.init();
        }
    }

    public void setDay(int d) {
        if (d < 1) {
            d = 1;
        }
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.add(2, 1);
        tmpCalendar.add(5, -1);
        int maxDaysInMonth = tmpCalendar.get(5);
        if (d > maxDaysInMonth) {
            d = maxDaysInMonth;
        }
        int oldDay = this.day;
        this.day = d;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        int i = 7;
        while (i < 49) {
            if (this.days[i].getText().equals(Integer.toString(this.day))) {
                this.selectedDay = this.days[i];
                this.selectedDay.setBackground(this.selectedColor);
                break;
            }
            ++i;
        }
        if (this.alwaysFireDayProperty) {
            this.firePropertyChange("day", 0, this.day);
        } else {
            this.firePropertyChange("day", oldDay, this.day);
        }
    }

    public void setAlwaysFireDayProperty(boolean alwaysFire) {
        this.alwaysFireDayProperty = alwaysFire;
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int month) {
        this.calendar.set(2, month);
        boolean storedMode = this.alwaysFireDayProperty;
        this.alwaysFireDayProperty = false;
        this.setDay(this.day);
        this.alwaysFireDayProperty = storedMode;
        this.drawDays();
        this.drawWeeks();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.drawDays();
        this.drawWeeks();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    public void setFont(Font font) {
        if (this.days != null) {
            int i = 0;
            while (i < 49) {
                this.days[i].setFont(font);
                ++i;
            }
        }
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        if (this.days != null) {
            int i = 7;
            while (i < 49) {
                this.days[i].setForeground(foreground);
                ++i;
            }
            this.drawDays();
        }
    }

    public String getName() {
        return "JDayChooser";
    }

    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String buttonText = button.getText();
        int day = new Integer(buttonText);
        if (day == this.day) {
            this.day = 0;
        }
        this.setDay(day);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int offset = e.getKeyCode() == 38 ? -7 : (e.getKeyCode() == 40 ? 7 : (e.getKeyCode() == 37 ? -1 : (e.getKeyCode() == 39 ? 1 : 0)));
        int newDay = this.getDay() + offset;
        if (newDay >= 1 && newDay <= this.calendar.getMaximum(5)) {
            this.setDay(newDay);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.days.length) {
            if (this.days[i] != null) {
                this.days[i].setEnabled(enabled);
            }
            i = (short)(i + 1);
        }
        i = 0;
        while (i < this.weeks.length) {
            if (this.weeks[i] != null) {
                this.weeks[i].setEnabled(enabled);
            }
            i = (short)(i + 1);
        }
    }

    public boolean isWeekOfYearVisible() {
        return this.weekOfYearVisible;
    }

    public void setWeekOfYearVisible(boolean weekOfYearVisible) {
        if (weekOfYearVisible == this.weekOfYearVisible) {
            return;
        }
        if (weekOfYearVisible) {
            this.add((Component)this.weekPanel, "West");
        } else {
            this.remove(this.weekPanel);
        }
        this.weekOfYearVisible = weekOfYearVisible;
        this.validate();
        this.dayPanel.validate();
    }

    public JPanel getDayPanel() {
        return this.dayPanel;
    }

    public Color getDecorationBackgroundColor() {
        return this.decorationBackgroundColor;
    }

    public void setDecorationBackgroundColor(Color decorationBackgroundColor) {
        int i;
        this.decorationBackgroundColor = decorationBackgroundColor;
        if (this.days != null) {
            i = 0;
            while (i < 7) {
                this.days[i].setBackground(decorationBackgroundColor);
                ++i;
            }
        }
        if (this.weeks != null) {
            i = 0;
            while (i < 7) {
                this.weeks[i].setBackground(decorationBackgroundColor);
                ++i;
            }
        }
    }

    public Color getSundayForeground() {
        return this.sundayForeground;
    }

    public Color getWeekdayForeground() {
        return this.weekdayForeground;
    }

    public void setSundayForeground(Color sundayForeground) {
        this.sundayForeground = sundayForeground;
        this.drawDayNames();
        this.drawDays();
    }

    public void setWeekdayForeground(Color weekdayForeground) {
        this.weekdayForeground = weekdayForeground;
        this.drawDayNames();
        this.drawDays();
    }

    public void setFocus() {
        if (this.selectedDay != null) {
            this.selectedDay.requestFocus();
        }
    }

    public boolean isDecorationBackgroundVisible() {
        return this.decorationBackgroundVisible;
    }

    public void setDecorationBackgroundVisible(boolean decorationBackgroundVisible) {
        this.decorationBackgroundVisible = decorationBackgroundVisible;
        this.initDecorations();
    }

    public boolean isDecorationBordersVisible() {
        return this.decorationBordersVisible;
    }

    public void setDecorationBordersVisible(boolean decorationBordersVisible) {
        this.decorationBordersVisible = decorationBordersVisible;
        this.initDecorations();
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JDayChooser");
        frame.getContentPane().add(new BBJDayChooser());
        frame.pack();
        frame.setVisible(true);
    }

    private class ButtonCal
    extends JButton {
        private boolean ultimalinha;
        private boolean ultimacoluna;
        private boolean titulo;
        private boolean domingo;

        public ButtonCal() {
            this.ultimalinha = false;
            this.ultimacoluna = false;
            this.titulo = false;
            this.domingo = false;
            this.initComponents();
        }

        public ButtonCal(String texto) {
            super(texto);
            this.ultimalinha = false;
            this.ultimacoluna = false;
            this.titulo = false;
            this.domingo = false;
            this.initComponents();
        }

        private void initComponents() {
            this.setVisible(true);
            this.setFocusable(false);
            this.setRolloverEnabled(false);
            this.setBackground(BBJEstilos.LABELTEXTO.getBackcolor());
            this.setForeground(BBJEstilos.LABELTEXTO.getColor());
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.ultimalinha = false;
            this.ultimacoluna = false;
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.getBackground());
            g.fillRect(1, 1, this.getWidth() - (1 + (this.isUltimacoluna() ? 1 : 0)), this.getHeight() - (1 + (this.isUltimalinha() ? 1 : 0)));
            int posicx = (int)((this.getSize().getWidth() - (double)this.getTextoWidth()) / 2.0);
            g.setColor(this.getForeground());
            Font font = BBJEstilos.LABELTEXTO.getFont();
            g.setFont(new Font(font.getName(), this.isTitulo() || this.isDomingo() ? 1 : 0, font.getSize()));
            g.drawString(this.getText(), posicx, 14);
        }

        public int getTextoWidth() {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.getFont().getStringBounds(this.getText(), frc);
            return (int)bounds.getWidth();
        }

        public boolean isUltimalinha() {
            return this.ultimalinha;
        }

        public void setUltimalinha(boolean ultimalinha) {
            this.ultimalinha = ultimalinha;
        }

        public boolean isUltimacoluna() {
            return this.ultimacoluna;
        }

        public void setUltimacoluna(boolean ultimacoluna) {
            this.ultimacoluna = ultimacoluna;
        }

        public boolean isTitulo() {
            return this.titulo;
        }

        public void setTitulo(boolean titulo) {
            this.titulo = titulo;
        }

        public boolean isDomingo() {
            return this.domingo;
        }

        public void setDomingo(boolean domingo) {
            this.domingo = domingo;
        }
    }
}

