/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class BBJHyperLink
extends JLabel {
    protected final Color LINK_COLOR = Color.GRAY;
    protected ActionListener listener = null;
    protected boolean underline;
    private BBJEstilos estilo;
    private String viewText;
    private boolean addlistener = false;
    private boolean sublinhado = false;
    private boolean ativo = true;
    private String viewName;
    protected MouseListener mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent me) {
            if (!BBJHyperLink.this.sublinhado && BBJHyperLink.this.ativo) {
                BBJHyperLink.this.underline = true;
                BBJHyperLink.this.repaint();
            }
        }

        public void mouseExited(MouseEvent me) {
            if (!BBJHyperLink.this.sublinhado && BBJHyperLink.this.ativo) {
                BBJHyperLink.this.underline = false;
                BBJHyperLink.this.repaint();
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (BBJHyperLink.this.ativo) {
                BBJHyperLink.this.fireActionEvent();
            }
        }
    };

    public BBJHyperLink() {
        this("");
    }

    public BBJHyperLink(String text) {
        this(text, "");
    }

    public void setText() {
        super.setText(this.viewText);
    }

    public BBJHyperLink(String viewText, String viewName) {
        super(viewText);
        this.setViewText(viewText);
        this.setViewName(viewName);
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (this.estilo != null) {
            this.setForeground(this.estilo.getColor());
        } else {
            this.setForeground(this.LINK_COLOR);
        }
        this.addMouseListener(this.mouseListener);
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    protected void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 1001, this.getText());
        if (this.listener != null) {
            this.listener.actionPerformed(e);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline) {
            Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g);
            int y = this.getHeight() / 2 + (int)(textBounds.getHeight() / 2.0);
            int w = (int)textBounds.getWidth();
            int x = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
            g.setColor(this.getForeground());
            g.drawLine(0, y, x + w, y);
        }
    }

    public String toString() {
        return this.getViewText();
    }

    public String getViewName() {
        if (this.viewName == null) {
            return "";
        }
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewText(String viewText) {
        this.viewText = viewText;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isAddlistener() {
        return this.addlistener;
    }

    public void setAddlistener(boolean addlistener) {
        this.addlistener = addlistener;
    }

    public BBJEstilos getEstilo() {
        return this.estilo;
    }

    public void setEstilo(BBJEstilos estilo) {
        this.estilo = estilo;
        if (estilo != null) {
            this.setForeground(estilo.getColor());
            this.setFont(estilo.getFont());
        }
    }

    public boolean isSublinhado() {
        return this.sublinhado;
    }

    public void setSublinhado(boolean sublinhado) {
        this.sublinhado = sublinhado;
        this.underline = sublinhado;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
        if (this.ativo) {
            this.addMouseListener(this.mouseListener);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.removeMouseListener(this.mouseListener);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public boolean isAtivo() {
        return this.ativo;
    }
}

