/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJMask;
import br.com.politec.infra.util.UtilLog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMaskLabel
extends JPanel {
    private String titulo;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJMask jtfCampo;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private JLabel jlTitulo;
    private String toolTip = "";

    private JLabel getJlTitulo() {
        if (this.jlTitulo == null) {
            this.jlTitulo = new JLabel();
            this.jlTitulo.setText("");
        }
        return this.jlTitulo;
    }

    public BBJMaskLabel(String titulo, boolean isEditavel, int posicaoLabel) {
        this(titulo, isEditavel, posicaoLabel, 0);
    }

    public BBJMaskLabel(String titulo, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJMaskLabel(String titulo, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.setMaximumSize(new Dimension(1500, this.posicaoLabel == 0 ? 19 : 38));
        this.jtfCampo = new BBJMask();
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.jtfCampo.setPreferredSize(dimfld);
            this.jtfCampo.setSize(dimfld);
        }
        this.jtfCampo.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.jtfCampo.setForeground(this.estilotexto.getColor());
        this.jtfCampo.setFont(this.estilotexto.getFont());
        this.configuraFonteEFundo();
        if (this.posicaoLabel == 0) {
            this.getJlTitulo().setText(this.getTitulo());
            this.add(this.getJlTitulo());
        }
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.getJlTitulo().getFont().getStringBounds(this.getTitulo(), frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 15)));
            }
        }
        this.add(this.jtfCampo);
    }

    private void configuraFonteEFundo() {
        this.getJlTitulo().setFont(this.estilolabel.getFont());
        this.getJlTitulo().setForeground(this.estilolabel.getColor());
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.jtfCampo.getHeight() + 5);
            g.drawString(this.getTitulo(), 2, posiy);
        }
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        this.removeAll();
        this.initialize();
    }

    public BBJMask getJtfCampo() {
        return this.jtfCampo;
    }

    public void setJtfCampo(BBJMask jtfCampo) {
        this.jtfCampo = jtfCampo;
    }

    public String getText() {
        return this.jtfCampo.getText();
    }

    public void setText(String texto) {
        this.jtfCampo.setMaskText(texto);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public String getMask() {
        return this.getJtfCampo().getMask();
    }

    public void setMask(String newMask) {
        this.getJtfCampo().setMask(newMask);
    }

    public void requestFocus() {
        this.getJtfCampo().requestFocus();
    }

    public void setEnabled(boolean enabled) {
        this.getJtfCampo().setEnabled(enabled);
        this.getJtfCampo().setToolTipText(enabled ? this.toolTip : null);
    }

    public void setToolTipText(String text) {
        this.getJtfCampo().setToolTipText(text);
        this.toolTip = text;
    }

    public void setData(String textoComplemento) {
        try {
            this.getJtfCampo().setData(textoComplemento);
        }
        catch (InvalidObjectException e) {
            UtilLog.getLog().debug(e);
        }
    }
}

