/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJMask;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelCEP;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJMaskLabelGeral
extends JPanel {
    private String titulo;
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJMask jtfCampo;
    private Color corFundo = new Color(255, 255, 255);
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private int tipo = -1;
    private Map<Integer, BBJMask> mapTipo = null;
    private String mascara;

    public BBJMaskLabelGeral(int tipo, int maxchar, boolean isEditavel, int posicaoLabel) {
        this(tipo, maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJMaskLabelGeral(String nome, int tipo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel, String mascara) {
        this.setTipo(tipo);
        this.titulo = nome == null ? "N\u00ba Inscri\u00e7\u00e3o:" : nome;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.mascara = mascara;
        this.initialize();
    }

    public BBJMaskLabelGeral(int tipo, int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(null, tipo, maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJMaskLabelGeral(String nome, int tipo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this(nome, tipo, maxchar, isEditavel, posicaoLabel, largura, larguralabel, " ");
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setBackground(this.corFundo);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.jtfCampo = this.getMapTipo().get(this.getTipo());
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.jtfCampo.setPreferredSize(dimfld);
        }
        this.jtfCampo.setEditable(this.isEditavel());
        this.jtfCampo.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.jtfCampo.setForeground(this.estilotexto.getColor());
        this.jtfCampo.setFont(this.estilotexto.getFont());
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.jtfCampo);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.jtfCampo.getHeight() + 5);
            g.drawString(this.getTitulo(), 2, posiy);
        }
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMascara(int tipo) {
        if (tipo == BBJMask.TIPO_CNPJ) {
            this.jtfCampo.setMask("##.###.###/####-##");
        } else if (tipo == BBJMask.TIPO_CPF) {
            this.jtfCampo.setMask("###.###.###-##");
        }
        this.repaint();
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJMask getJtfCampo() {
        return this.jtfCampo;
    }

    @Override
    public void setToolTipText(String text) {
        this.getJtfCampo().setToolTipText(text);
    }

    public void setJtfCampo(BBJMask jtfCampo) {
        this.jtfCampo = jtfCampo;
    }

    public String getText() {
        return this.jtfCampo.getText().trim();
    }

    public void setText(String text) {
        this.jtfCampo.setText(text);
    }

    public void setTextWithMask(String text) throws InvalidObjectException {
        this.jtfCampo.setTextWithMask(text);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public static void main(String[] a) {
        JFrame frm = new JFrame();
        frm.add(new BBJMaskLabelCEP(10, true, 0));
        frm.setSize(new Dimension(200, 200));
        frm.setPreferredSize(new Dimension(200, 200));
        frm.setVisible(true);
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    @Override
    public void setName(String name) {
        this.jtfCampo.setName(name);
    }

    public Map<Integer, BBJMask> getMapTipo() {
        if (this.mapTipo == null) {
            this.mapTipo = new HashMap<Integer, BBJMask>();
            this.mapTipo.put(BBJMask.TIPO_CPF, new BBJMask("###.###.###-##", BBJMask.TIPO_CPF));
            this.mapTipo.put(BBJMask.TIPO_CNPJ, new BBJMask("##.###.###/####-##", BBJMask.TIPO_CNPJ));
            this.mapTipo.put(BBJMask.TIPO_AGENCIA, new BBJMask("####-&", BBJMask.TIPO_AGENCIA));
            this.mapTipo.put(BBJMask.TIPO_CEI, new BBJMask("##.###.#####/##", BBJMask.TIPO_CEI));
            this.mapTipo.put(BBJMask.TIPO_CEP, new BBJMask("#####-###", BBJMask.TIPO_CEP));
            this.mapTipo.put(BBJMask.TIPO_CONTA, new BBJMask("##.###.###.###-&", BBJMask.TIPO_CONTA));
            this.mapTipo.put(BBJMask.TIPO_DEBCAD, new BBJMask("#.###.###-##", BBJMask.TIPO_DEBCAD));
            this.mapTipo.put(BBJMask.TIPO_NB, new BBJMask("###.###.###-#", BBJMask.TIPO_NB));
            this.mapTipo.put(BBJMask.TIPO_NIT, new BBJMask("###.#####.##-#", BBJMask.TIPO_NIT));
            this.mapTipo.put(BBJMask.TIPO_PASEP, new BBJMask("###.#####.##-#", BBJMask.TIPO_PASEP));
            this.mapTipo.put(BBJMask.TIPO_PIS, new BBJMask("###.#####.##-#", BBJMask.TIPO_PIS));
            this.mapTipo.put(BBJMask.TIPO_REFERENCIA, new BBJMask("##############", BBJMask.TIPO_REFERENCIA));
            this.mapTipo.put(BBJMask.TIPO_LINHA_DIGITAVEL_GUIA, new BBJMask("###########-#", BBJMask.TIPO_LINHA_DIGITAVEL_GUIA));
            this.mapTipo.put(BBJMask.TIPO_LINHA_DIGITAVEL_TIT_01, new BBJMask("#####.#####", BBJMask.TIPO_LINHA_DIGITAVEL_TIT_01));
            this.mapTipo.put(BBJMask.TIPO_LINHA_DIGITAVEL_TIT_02_03, new BBJMask("#####.######", BBJMask.TIPO_LINHA_DIGITAVEL_TIT_02_03));
            this.mapTipo.put(BBJMask.TIPO_NOSSO_NUMERO, new BBJMask("##.###.###.###-#", BBJMask.TIPO_NOSSO_NUMERO));
            this.mapTipo.put(BBJMask.TIPO_LINHA_CODIGO_BARRAS, new BBJMask("############################################", BBJMask.TIPO_LINHA_CODIGO_BARRAS));
            this.mapTipo.put(BBJMask.TIPO_TITULOCOBRANCA, new BBJMask("##############", BBJMask.TIPO_TITULOCOBRANCA));
            this.mapTipo.put(BBJMask.FORNECIDA_USUARIO, new BBJMask(this.mascara, BBJMask.FORNECIDA_USUARIO));
        }
        return this.mapTipo;
    }

    public void setMapTipo(Map<Integer, BBJMask> mapTipo) {
        this.mapTipo = mapTipo;
    }
}

