/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJDecimalTextField;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.IComponent;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMaskLabelMonetario
extends JPanel
implements IComponent {
    private String titulo;
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private String hint = "";
    private boolean editavel = true;
    private BBJDecimalTextField decimalTextField;
    private Color corFundo = new Color(255, 255, 255);
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private JLabel jlTitulo;

    public BBJMaskLabelMonetario(String titulo, int maxchar, boolean isEditavel, int posicaoLabel) {
        this(titulo, maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJMaskLabelMonetario(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJMaskLabelMonetario(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setBackground(this.corFundo);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.getDecimalTextField().setPreferredSize(dimfld);
        }
        this.getDecimalTextField().setMaximumSize(new Dimension(3000, 19));
        this.getDecimalTextField().setEditable(this.isEditavel());
        this.getDecimalTextField().setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.getDecimalTextField().setForeground(this.estilotexto.getColor());
        this.getDecimalTextField().setFont(this.estilotexto.getFont());
        this.getDecimalTextField().setMaxChars(this.getMaxchar());
        this.setJlTitulo(new JLabel(this.titulo));
        this.getJlTitulo().setFont(this.estilolabel.getFont());
        this.getJlTitulo().setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            this.getJlTitulo().setText(this.titulo);
        }
        this.add(this.getJlTitulo());
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.getJlTitulo().getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.getDecimalTextField());
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.getDecimalTextField().addFocusListener(l);
    }

    public void setName(String name) {
        this.getDecimalTextField().setName(name);
    }

    public void setToolTipText(String toolTip) {
        this.setHint(toolTip);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 8);
        }
    }

    public void setHint(String text) {
        this.hint = text;
        this.getDecimalTextField().setToolTipText(text);
    }

    public void setEnabled(boolean enabled) {
        this.getDecimalTextField().setEnabled(enabled);
        this.getDecimalTextField().setToolTipText(enabled ? this.hint : null);
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJDecimalTextField getDecimalTextField() {
        if (this.decimalTextField == null) {
            this.decimalTextField = new BBJDecimalTextField();
        }
        return this.decimalTextField;
    }

    public String getText() {
        return this.getDecimalTextField().getText();
    }

    public void setText(String text) {
        this.getDecimalTextField().setText(text);
    }

    public BigDecimal getValorDecimal() {
        return new BigDecimal(this.converterParaDouble(this.getText()));
    }

    protected Double converterParaDouble(String real) {
        String valor = real;
        while (real.indexOf(".") > -1) {
            real = real.replace(".", "");
        }
        return UtilConversorDeDouble.converterParaDoubleWrapper(valor);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public static void main(String[] a) {
        JFrame frm = new JFrame();
        BBJMaskLabelMonetario bbjMaskLabelMonetario = new BBJMaskLabelMonetario("teste componente", 10, true, 0);
        frm.add(bbjMaskLabelMonetario);
        frm.setSize(new Dimension(200, 200));
        frm.setPreferredSize(new Dimension(200, 200));
        bbjMaskLabelMonetario.setText("22100");
        frm.setVisible(true);
    }

    public void setValor(String texto) {
        this.getDecimalTextField().setText(texto);
    }

    public void setValor(Number numero) {
        this.setFomartar(false);
        this.getDecimalTextField().setText(UtilFormatadorDeReal.formatar(numero));
        this.setFomartar(true);
    }

    private void setFomartar(boolean formata) {
        this.getDecimalTextField().getDecimalDocument().setFormatar(formata);
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public void forcarTamanhoDoCampoMascara(Dimension dimension) {
        this.getDecimalTextField().setMinimumSize(dimension);
        this.getDecimalTextField().setMaximumSize(dimension);
        this.getDecimalTextField().setPreferredSize(dimension);
    }

    public String getTituloLabel() {
        return this.getJlTitulo().getText();
    }

    public void setTituloLabel(String titulo) {
        this.getJlTitulo().setText(titulo);
    }
}

