/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelCEP;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskTextField;
import br.com.bb.plugins.gac.util.swing.componente.IComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMaskTextFieldLabel
extends JPanel
implements IComponent {
    private String titulo;
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private BBJMaskTextField campoMascara;
    private Color corFundo = new Color(255, 255, 255);
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private String toolTip;
    private JLabel jlTitulo;

    public BBJMaskTextFieldLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel) {
        this(titulo, maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJMaskTextFieldLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public BBJMaskTextFieldLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setBackground(this.corFundo);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.campoMascara = new BBJMaskTextField("##########");
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.campoMascara.setPreferredSize(dimfld);
        }
        this.campoMascara.setMaximumSize(new Dimension(3000, 19));
        this.campoMascara.setEditable(this.isEditavel());
        this.campoMascara.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.campoMascara.setForeground(this.estilotexto.getColor());
        this.campoMascara.setFont(this.estilotexto.getFont());
        this.setJlTitulo(new JLabel(" "));
        this.getJlTitulo().setFont(this.estilolabel.getFont());
        this.getJlTitulo().setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            this.getJlTitulo().setText(this.titulo);
        }
        this.add(this.getJlTitulo());
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.getJlTitulo().getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.campoMascara);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 8);
        }
    }

    public void setName(String name) {
        this.getCampoMascara().setName(name);
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.getCampoMascara().setEditable(editavel);
        this.getCampoMascara().setBackground(editavel ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.editavel = editavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJMaskTextField getCampoMascara() {
        return this.campoMascara;
    }

    public String getText() {
        return this.campoMascara.getText();
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public static void main(String[] a) {
        JFrame frm = new JFrame();
        frm.add(new BBJMaskLabelCEP(10, true, 0));
        frm.setSize(new Dimension(200, 200));
        frm.setPreferredSize(new Dimension(200, 200));
        frm.setVisible(true);
    }

    public void setMascara(String mascaraCampo) {
        this.getCampoMascara().setMascaraCampo(mascaraCampo);
    }

    public void setText(String string) {
        this.campoMascara.setText(string);
    }

    public void setEnabled(boolean enabled) {
        this.campoMascara.setEnabled(enabled);
        this.campoMascara.setToolTipText(enabled ? this.toolTip : null);
    }

    public void setToolTipText(String toolTip) {
        this.campoMascara.setToolTipText(toolTip);
        this.toolTip = toolTip;
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public void forcarTamanhoDoCampoMascara(Dimension d) {
        this.getCampoMascara().setMinimumSize(new Dimension(170, 20));
        this.getCampoMascara().setMaximumSize(new Dimension(170, 20));
        this.getCampoMascara().setPreferredSize(new Dimension(170, 20));
    }

    public String getTituloLabel() {
        return this.getJlTitulo().getText();
    }

    public void setTituloLabel(String titulo) {
        this.getJlTitulo().setText(titulo);
    }
}

