/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMensagemPagina
extends JPanel
implements ActionListener {
    public static final int MENSAGEM_AVISO = 0;
    public static final int MENSAGEM_PERGUNTA = 1;
    public static final int MENSAGEM_ATENCAO = 2;
    public static final int MENSAGEM_PARABENS = 3;
    private ImageIcon imgMensagem = null;
    private int tipomensagem = 0;
    private String mensagem = "";
    private JPanel panelMain;
    private JPanel panelMensagem;
    private JLabel labelMensagem;
    private BBJPanelBotoesManut panelBotoes;
    private ActionListener listener;

    public BBJMensagemPagina(int tipomensagem) {
        this(tipomensagem, "");
    }

    public BBJMensagemPagina(int tipomensagem, String mensagem) {
        this.setTipomensagem(tipomensagem);
        this.setMensagem(mensagem);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder(BBJBordaOval.createOvalBorder());
        this.setBackground(Color.WHITE);
        this.add((Component)this.getPanelMain(), "Center");
        this.configurarBotoes();
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setOpaque(true);
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.setBackground(BBJEstilos.MENSAGEMPAGINA.getBackcolor());
            this.panelMain.add((Component)this.getPanelMensagem(), "Center");
            this.panelMain.add((Component)this.getPanelBotoes(), "South");
        }
        return this.panelMain;
    }

    private void configurarBotoes() {
        switch (this.tipomensagem) {
            case 0: {
                this.getPanelBotoes().setBotoes(new String[]{"FECHAR"});
                break;
            }
            case 1: {
                this.getPanelBotoes().setBotoes(new String[]{"SIM", "N\u00c3O", "FECHAR"});
                break;
            }
            case 2: {
                this.getPanelBotoes().setBotoes(new String[]{"FECHAR"});
                break;
            }
            case 3: {
                this.getPanelBotoes().setBotoes(new String[]{"FECHAR"});
            }
        }
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new BBJPanelBotoesManut(new String[]{"OK", "FECHAR"}, 1);
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.addActionListener(this);
            this.panelBotoes.setPreferredSize(new Dimension(0, 30));
        }
        return this.panelBotoes;
    }

    public JPanel getPanelMensagem() {
        if (this.panelMensagem == null) {
            this.panelMensagem = new JPanel();
            this.panelMensagem.setOpaque(false);
            this.panelMensagem.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(15, 70, 15, 5);
            gbc.fill = 1;
            gbc.weightx = 0.99;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.panelMensagem.setPreferredSize(new Dimension(0, 40));
            this.panelMensagem.add((Component)this.getLabelMensagem(), gbc);
        }
        return this.panelMensagem;
    }

    public JLabel getLabelMensagem() {
        if (this.labelMensagem == null) {
            this.labelMensagem = new JLabel(this.getMensagem());
            this.labelMensagem.setOpaque(false);
            this.labelMensagem.setFont(BBJEstilos.MENSAGEMPAGINA.getFont());
            this.labelMensagem.setForeground(BBJEstilos.MENSAGEMPAGINA.getColor());
        }
        return this.labelMensagem;
    }

    public void paint(Graphics g) {
        super.paint(g);
        switch (this.tipomensagem) {
            case 0: {
                this.imgMensagem = this.getImageIcon("/images/ico_info.gif");
                break;
            }
            case 1: {
                this.imgMensagem = this.getImageIcon("/images/bt_atencao.gif");
                break;
            }
            case 2: {
                this.imgMensagem = this.getImageIcon("/images/bt_atencao.gif");
                break;
            }
            case 3: {
                this.imgMensagem = this.getImageIcon("/images/bt_parabens.gif");
            }
        }
        if (this.imgMensagem != null && this.imgMensagem.getIconHeight() > 0) {
            g.drawImage(this.imgMensagem.getImage(), 20, 20, null, null);
        }
    }

    private ImageIcon getImageIcon(String image) {
        if (image == null || image.trim().length() == 0) {
            return null;
        }
        return new ImageIcon(this.getClass().getResource(image));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("FECHAR")) {
            this.setVisible(false);
        } else {
            this.fireAction(e);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null && event != null) {
            this.listener.actionPerformed(event);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Teste de Mensagem");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(600, 400));
        panel.setBackground(Color.WHITE);
        BBJMensagemPagina msg = new BBJMensagemPagina(2);
        msg.setMensagem("Confirma a altera\u00e7\u00e3o?");
        panel.add((Component)msg, "North");
        frame.setContentPane(panel);
        frame.setPreferredSize(new Dimension(600, 400));
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        frame.pack();
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
        this.getLabelMensagem().setText("<html>" + mensagem + "</html>");
    }

    public int getTipomensagem() {
        return this.tipomensagem;
    }

    public void setTipomensagem(int tipomensagem) {
        this.tipomensagem = tipomensagem;
        this.configurarBotoes();
    }
}

