/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJDayChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BBJMonthChooser
extends JPanel
implements ItemListener,
ChangeListener {
    protected boolean hasSpinner;
    private Locale locale;
    private int month;
    private int oldSpinnerValue = 0;
    private BBJDayChooser dayChooser;
    private BBJYearChooser yearChooser;
    private JComboBox comboBox;
    private JSpinner spinner;
    private boolean initialized;
    private boolean localInitialize;

    public BBJMonthChooser() {
        this(true);
    }

    public BBJMonthChooser(boolean hasSpinner) {
        this.hasSpinner = hasSpinner;
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.comboBox.setFont(BBJEstilos.LABELTEXTO.getFont());
        this.comboBox.setForeground(BBJEstilos.LABELTEXTO.getColor());
        this.comboBox.setBackground(Color.WHITE);
        this.locale = Locale.getDefault();
        this.initNames();
        if (hasSpinner) {
            this.spinner = new JSpinner();
            this.spinner.addChangeListener(this);
            this.comboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.spinner.setEditor(this.comboBox);
            this.add((Component)this.spinner, "West");
        } else {
            this.add((Component)this.comboBox, "West");
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        int i = 0;
        while (i < 12) {
            this.comboBox.addItem(monthNames[i]);
            ++i;
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    public void stateChanged(ChangeEvent e) {
        SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)e.getSource()).getModel();
        int value = model.getNumber().intValue();
        boolean increase = value > this.oldSpinnerValue;
        this.oldSpinnerValue = value;
        int month = this.getMonth();
        if (increase) {
            if (++month == 12) {
                month = 0;
                if (this.yearChooser != null) {
                    int year = this.yearChooser.getYear();
                    this.yearChooser.setYear(++year);
                }
            }
        } else if (--month == -1) {
            month = 11;
            if (this.yearChooser != null) {
                int year = this.yearChooser.getYear();
                this.yearChooser.setYear(--year);
            }
        }
        this.setMonth(month);
    }

    public void itemStateChanged(ItemEvent e) {
        int index;
        if (e.getStateChange() == 1 && (index = this.comboBox.getSelectedIndex()) >= 0 && index != this.month) {
            this.setMonth(index, false);
        }
    }

    private void setMonth(int newMonth, boolean select) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int oldMonth = this.month;
        this.month = newMonth;
        if (select) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", oldMonth, this.month);
    }

    public void setMonth(int newMonth) {
        if (newMonth < 0 || newMonth > 11) {
            return;
        }
        this.setMonth(newMonth, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(BBJDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public void setYearChooser(BBJYearChooser yearChooser) {
        this.yearChooser = yearChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.initNames();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
        if (this.spinner != null) {
            this.spinner.setEnabled(enabled);
        }
    }

    public Component getComboBox() {
        return this.comboBox;
    }

    public Component getSpinner() {
        return this.spinner;
    }

    public boolean hasSpinner() {
        return this.hasSpinner;
    }

    public String getName() {
        return "JMonthChooser";
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("MonthChooser");
        frame.getContentPane().add(new BBJMonthChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

