/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJRadioButtonList<T>
extends JList {
    private T[] opcoesLista;
    private JScrollPane scroll = new JScrollPane();
    private boolean zebrado = true;

    public BBJRadioButtonList() {
        this.zebrado = true;
        this.setCellRenderer(new RadioButtonListCellRenderer());
        this.scroll.add(this);
    }

    public BBJRadioButtonList(T[] opcoes) {
        this.opcoesLista = opcoes;
        this.setListData(this.opcoesLista);
        this.setCellRenderer(new RadioButtonListCellRenderer());
        JScrollPane scroll = new JScrollPane();
        scroll.add(this);
        this.zebrado = true;
    }

    public void carregaLista(T[] opcoes) {
        this.opcoesLista = opcoes;
        this.setListData(this.opcoesLista);
    }

    public T getSelected() {
        return (T)super.getSelectedValue();
    }

    public boolean isZebrado() {
        return this.zebrado;
    }

    public void setZebrado(boolean zebrado) {
        this.zebrado = zebrado;
    }

    private class RadioButtonListCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel();
        public JRadioButton radioButton;
        private final Color linhaBranca = Color.WHITE;
        private final Color linhaCinza = new Color(246, 246, 246);

        private RadioButtonListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setOpaque(false);
            label.setFont(new Font("Arial", 0, 12));
            label.setForeground(new Color(102, 102, 102));
            label.setBorder(null);
            if (this.panel.getComponentCount() == 0) {
                this.radioButton = new JRadioButton();
                this.radioButton.setOpaque(false);
                this.panel.add(Box.createRigidArea(new Dimension(10, 0)));
                this.panel.add(this.radioButton);
                this.panel.add(label);
            }
            this.radioButton.setSelected(isSelected);
            if (BBJRadioButtonList.this.zebrado) {
                this.panel.setBackground(index % 2 == 0 ? this.linhaBranca : this.linhaCinza);
            } else {
                this.panel.setOpaque(false);
            }
            return this.panel;
        }
    }
}

