/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextArea;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BBJTextAreaLabel
extends JPanel {
    private String titulo;
    private int largura;
    private int maxchar;
    private int larguralabel;
    private int altura;
    private int posicaoLabel = 0;
    private boolean isEditavel = true;
    private JLabel jlTitulo;
    public BBJTextArea jtaAreaTexto;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;

    public BBJTextAreaLabel(String titulo, int maxchar, int largura, int altura, boolean isEditavel, int posicaoLabel) {
        this.titulo = titulo;
        this.largura = largura;
        this.altura = altura;
        this.posicaoLabel = posicaoLabel;
        this.isEditavel = isEditavel;
        this.maxchar = maxchar;
        this.initialize();
    }

    public BBJTextAreaLabel(String titulo, int maxchar, int largura, int altura, boolean isEditavel, int posicaoLabel, int larguraLabel) {
        this.titulo = titulo;
        this.largura = largura;
        this.altura = altura;
        this.posicaoLabel = posicaoLabel;
        this.isEditavel = isEditavel;
        this.larguralabel = larguraLabel;
        this.maxchar = maxchar;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.jtaAreaTexto = new BBJTextArea();
        this.jtaAreaTexto.setMaxChar(this.maxchar);
        JScrollPane scroll = new JScrollPane(this.jtaAreaTexto);
        scroll.setPreferredSize(new Dimension(this.largura, this.altura));
        this.jtaAreaTexto.setLineWrap(true);
        this.jtaAreaTexto.setEditable(this.isEditavel());
        this.jtaAreaTexto.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(scroll);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 8);
        }
    }

    public boolean isEditavel() {
        return this.isEditavel;
    }

    public void setEditavel(boolean isEditavel) {
        this.isEditavel = isEditavel;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getAltura() {
        return this.altura;
    }

    public void setAltura(int altura) {
        this.altura = altura;
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJTextArea getJtaAreaTexto() {
        return this.jtaAreaTexto;
    }

    public void setJtaAreaTexto(BBJTextArea jtaAreaTexto) {
        this.jtaAreaTexto = jtaAreaTexto;
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }
}

