/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJText;
import br.com.bb.plugins.gac.util.swing.componente.IComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJTextLabel
extends JPanel
implements IComponent {
    private String titulo;
    private int maxchar;
    private int largura;
    private int larguralabel;
    private int posicaoLabel = 0;
    private boolean editavel = true;
    private int tipoEntrada = 2;
    private BBJText jtfCampo;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    public static final int SO_CHARACTER = 0;
    public static final int SO_NUMER0 = 1;
    public static final int SO_NUMERO_E_CARACTER = 2;
    public static final int SO_NUMERO_E_CARACTER_SEM_ESPACO = 3;
    public static final int ESPECIAL_PARA_EMAIL = 4;
    public static final int ESPECIAL_PARA_FORMATO = 6;
    public static final int ESPECIAL_PARA_CONTATO = 10;
    public static final int TODOS_CARACTERES = 99;
    private BBJEstilos estilotexto;
    private BBJEstilos estilotextoNaoEditavel;
    private BBJEstilos estilolabel;
    private JLabel jlTitulo;

    public BBJTextLabel() {
    }

    public BBJTextLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel) {
        this(titulo, maxchar, isEditavel, posicaoLabel, 0);
    }

    public BBJTextLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura) {
        this(titulo, maxchar, isEditavel, posicaoLabel, largura, 0);
    }

    public void setToolTipText(String text) {
        this.getJtfCampo().setHint(text);
    }

    public BBJTextLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel, int tipoEntrada) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.tipoEntrada = tipoEntrada;
        this.initialize();
        this.setEnabled(isEditavel);
    }

    public BBJTextLabel(String titulo, int maxchar, boolean isEditavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.maxchar = maxchar;
        this.editavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilotextoNaoEditavel = BBJEstilos.TEXTONAOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.jtfCampo = new BBJText();
        this.jtfCampo.setMaxChar(this.maxchar);
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.jtfCampo.setPreferredSize(dimfld);
        }
        this.jtfCampo.setMinimumSize(new Dimension(0, 19));
        this.jtfCampo.setMaximumSize(new Dimension(2500, 19));
        this.jtfCampo.setTipoEntrada(this.tipoEntrada);
        this.jtfCampo.setEditable(this.isEditavel());
        this.jtfCampo.setBackground(this.isEditavel() ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.jtfCampo.setForeground(this.estilotexto.getColor());
        this.jtfCampo.setFont(this.estilotexto.getFont());
        this.criaTitulo();
        this.add(this.getJlTitulo());
        this.ajustaTitulo();
        this.add(this.jtfCampo);
        this.setEnabled(this.editavel);
    }

    private void ajustaTitulo() {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        Rectangle2D bounds = this.getJlTitulo().getFont().getStringBounds(this.titulo, frc);
        if ((double)this.larguralabel - bounds.getWidth() < 0.0) {
            this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 16)));
        } else if ((double)this.larguralabel - bounds.getWidth() >= 0.0) {
            this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 25)));
        }
    }

    public void criaTitulo() {
        this.setJlTitulo(new JLabel(""));
        this.getJlTitulo().setFont(this.estilolabel.getFont());
        this.getJlTitulo().setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            this.getJlTitulo().setText(this.titulo);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.jtfCampo.getHeight() + 5);
            g.drawString(this.titulo, 2, posiy);
        }
    }

    public void setEnabled(boolean enabled) {
        this.getJtfCampo().setEditable(enabled);
        this.getJtfCampo().setBackground(enabled ? this.estilotexto.getBackcolor() : this.estilotextoNaoEditavel.getBackcolor());
        this.editavel = enabled;
    }

    public boolean isEditavel() {
        return this.getJtfCampo().isEditable();
    }

    public void setEditavel(boolean editavel) {
        this.setEnabled(editavel);
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public int getMaxchar() {
        return this.maxchar;
    }

    public void setMaxchar(int maxchar) {
        this.maxchar = maxchar;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public BBJText getJtfCampo() {
        return this.jtfCampo;
    }

    public void setJtfCampo(BBJText jtfCampo) {
        this.jtfCampo = jtfCampo;
    }

    public String getText() {
        return this.jtfCampo.getText();
    }

    public void setText(String text) {
        this.jtfCampo.setText(text);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public void requestFocus() {
        this.getJtfCampo().requestFocus();
    }

    public void setName(String name) {
        this.jtfCampo.setName(name);
    }

    public int getTipoEntrada() {
        return this.tipoEntrada;
    }

    public void setTipoEntrada(int tipo) {
        this.tipoEntrada = tipo;
        this.getJtfCampo().setTipoEntrada(tipo);
    }

    public void setUpperCase(boolean uppercase) {
        this.getJtfCampo().setUpperCase(uppercase);
    }

    public void alteraTitulo(String titulo) {
        this.titulo = titulo;
        this.updateUI();
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public void forcarTamanhoDoCampoTexto(Dimension d) {
        this.getJtfCampo().setMinimumSize(new Dimension(170, 20));
        this.getJtfCampo().setMaximumSize(new Dimension(170, 20));
        this.getJtfCampo().setPreferredSize(new Dimension(170, 20));
    }

    public String getTituloLabel() {
        return this.getJlTitulo().getText();
    }

    public void setTituloLabel(String titulo) {
        this.getJlTitulo().setText(titulo);
    }
}

