/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.CheckNode;
import br.com.bb.plugins.gac.util.swing.componente.CheckRenderer;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BBJTreeCheckBox
extends JTree {
    protected ActionListener actLParent = null;

    public void setActLParent(ActionListener actLParent) {
        this.actLParent = actLParent;
    }

    public BBJTreeCheckBox(String s_titulo) {
        super(new CheckNode(s_titulo));
        Font defont = UIManager.getDefaults().getFont("Button.font");
        this.setFont(new Font(defont.getFamily(), 0, 12));
        this.setCellRenderer(new CheckRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addMouseListener(new NodeSelectionListener(this));
    }

    public void ExpandAll() {
        int icnt = 0;
        while (icnt < this.getRowCount()) {
            this.expandRow(icnt);
            ++icnt;
        }
    }

    public void AddNode(CheckNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ((CheckNode)model.getRoot()).add(node);
        this.updateUI();
    }

    public void RemoveNodes() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ((CheckNode)model.getRoot()).removeAllChildren();
        ((CheckNode)model.getRoot()).setSelected(false);
        this.updateUI();
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null && path.getLastPathComponent() instanceof CheckNode) {
                CheckNode node = (CheckNode)path.getLastPathComponent();
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

