/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BBMaskDocument
extends PlainDocument {
    public static final char MASCARA_NUMERO = '#';
    public static final char MASCARA_LETRA = 'A';
    public static final char MASCARA_CURINGA = '&';
    private String mascara = "";
    private int maxChars = 0;
    private int[] posicMaskChars = null;
    private char[] maskChars = null;
    private boolean upperCase = true;
    private boolean alinharDireita = false;

    public BBMaskDocument() {
        this("");
    }

    public BBMaskDocument(String mascara) {
        this.setMascara(mascara);
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StringBuffer textoInserido = new StringBuffer(str);
        StringBuffer textoCampo = new StringBuffer(this.getText(0, this.getLength()));
        if (textoCampo.length() < this.maxChars) {
            super.remove(0, this.getLength());
            textoCampo.insert(offs, textoInserido);
            this.removerCaracteres(textoCampo);
            if (this.isUpperCase()) {
                textoCampo = new StringBuffer(textoCampo.toString().toUpperCase());
            }
            this.removerValorInvalido(textoCampo);
            this.acrescentarMascara(textoCampo);
            if (textoCampo.length() > this.getMaxChars()) {
                textoCampo.delete(this.getMaxChars() - 1, textoCampo.length());
            }
            super.insertString(0, textoCampo.toString(), a);
        }
    }

    private void removerValorInvalido(StringBuffer textoCampo) {
        String mascaraLimpa = this.getMascaraLimpa();
        if (this.isAlinharDireita()) {
            int count = mascaraLimpa.length() - 1;
            while (count >= 0) {
                char maskChar = mascaraLimpa.charAt(count);
                int posicChar = textoCampo.length() - (mascaraLimpa.length() - count);
                if (textoCampo.length() > posicChar && posicChar >= 0) {
                    char charAt = textoCampo.charAt(posicChar);
                    if (maskChar == '#' && !Character.isDigit(charAt)) {
                        textoCampo.deleteCharAt(posicChar);
                    }
                    --count;
                    continue;
                }
                break;
            }
        } else {
            int count = 0;
            while (count < mascaraLimpa.length()) {
                if (textoCampo.length() > count) {
                    char maskChar = mascaraLimpa.charAt(count);
                    char charAt = textoCampo.charAt(count);
                    if (maskChar == '#' && !Character.isDigit(charAt)) {
                        textoCampo.deleteCharAt(count);
                    }
                    ++count;
                    continue;
                }
                break;
            }
        }
    }

    private void acrescentarMascara(StringBuffer textoAnterior) {
        if (this.posicMaskChars == null || this.posicMaskChars.length == 0) {
            return;
        }
        if (this.isAlinharDireita()) {
            int count = this.posicMaskChars.length - 1;
            while (count >= 0) {
                int posicaoDireita = this.getMascara().length() - this.posicMaskChars[count];
                if (textoAnterior.length() >= posicaoDireita) {
                    textoAnterior.insert(textoAnterior.length() - posicaoDireita + 1, this.maskChars[count]);
                }
                --count;
            }
        } else {
            int count = 0;
            while (count < this.posicMaskChars.length) {
                if (textoAnterior.length() > this.posicMaskChars[count]) {
                    textoAnterior.insert(this.posicMaskChars[count], this.maskChars[count]);
                }
                ++count;
            }
        }
    }

    private void removerCaracteres(StringBuffer textoAnterior) {
        int count = textoAnterior.length() - 1;
        while (count >= 0) {
            char charAt = textoAnterior.charAt(count);
            if (!Character.isDigit(charAt) && !this.isLetra(charAt)) {
                textoAnterior.deleteCharAt(count);
            }
            --count;
        }
    }

    private boolean isLetra(char charAt) {
        String upperChars = "ABCDEFGHIJKLMNOPQRSTUVXZ";
        int count = 0;
        while (count < upperChars.length()) {
            if (charAt == upperChars.charAt(count) || charAt == String.valueOf(upperChars.charAt(count)).toLowerCase().charAt(0)) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public String getMascaraLimpa() {
        StringBuffer mascaraLimpa = new StringBuffer();
        int icnt = 0;
        while (icnt < this.mascara.length()) {
            if (this.mascara.charAt(icnt) == '#' || this.mascara.charAt(icnt) == 'A' || this.mascara.charAt(icnt) == '&') {
                mascaraLimpa.append(this.mascara.charAt(icnt));
            }
            ++icnt;
        }
        return mascaraLimpa.toString();
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Teste");
                frame.setDefaultCloseOperation(2);
                JTextField numero = new JTextField();
                numero.setHorizontalAlignment(2);
                BBMaskDocument mask = new BBMaskDocument("###.###.###-&");
                mask.setAlinharDireita(true);
                numero.setHorizontalAlignment(4);
                numero.setDocument(mask);
                JTextField numero2 = new JTextField();
                numero2.setDocument(new BBMaskDocument("##.###.###/####-##"));
                numero2.setHorizontalAlignment(2);
                frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
                frame.getContentPane().add(numero);
                frame.getContentPane().add(numero2);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setMascara(String mascara) {
        if (mascara == null) {
            mascara = "";
        }
        this.mascara = mascara;
        this.setMaxChars(this.mascara.length());
        this.carregarMapaMasks();
    }

    private void carregarMapaMasks() {
        int icountMaskChars = this.getMascara().length() - this.getMascaraLimpa().length();
        if (icountMaskChars > 0) {
            this.posicMaskChars = new int[icountMaskChars];
            this.maskChars = new char[icountMaskChars];
            int posicMatriz = 0;
            int icnt = 0;
            while (icnt < this.mascara.length()) {
                if (this.mascara.charAt(icnt) != '#' && this.mascara.charAt(icnt) != 'A' && this.mascara.charAt(icnt) != '&') {
                    this.posicMaskChars[posicMatriz] = icnt;
                    this.maskChars[posicMatriz] = this.mascara.charAt(icnt);
                    ++posicMatriz;
                }
                ++icnt;
            }
        }
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public boolean isAlinharDireita() {
        return this.alinharDireita;
    }

    public void setAlinharDireita(boolean alinharDireita) {
        this.alinharDireita = alinharDireita;
    }
}

