/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.FormatadorNumero;
import br.com.bb.plugins.gac.util.swing.TableHdrRenderer;
import br.com.bb.plugins.gac.util.swing.componente.BBCollumnModel;
import br.com.politec.infra.util.UtilLog;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.beanutils.BeanUtils;

public class BBTableModel
extends DefaultTableModel
implements MouseListener {
    private JTable tabela = null;
    private Collection colecao = null;
    private Object[][] linhas = null;
    private Vector colunas = null;
    private String[] nomeColunas = null;
    private boolean sorted = true;
    private int[] ordem;
    public static final int CELULA_NORMAL = 0;
    public static final int CELULA_CPF_CNPJ = 1;
    public static final int CELULA_DATA = 2;
    public static final int CELULA_CHECK = 3;
    public static final int CELULA_DECIMAL = 4;
    public static final int CELULA_CPF_CNPJ_OUTROS = 5;
    public static final int CELULA_INDICATIVO = 6;
    public static final int CELULA_CENTRALIZAR = 7;
    public static final int CELULA_NOSSONUMERO = 8;

    public BBTableModel(Object[][] dados, String[] nomeColunas) {
        super(dados, nomeColunas);
    }

    public BBTableModel(Collection collection) {
        this.colecao = collection;
    }

    public void addColumn(String labelColuna, String nomeColuna, int size) {
        this.addColumn(labelColuna, nomeColuna, size, 0);
    }

    public void addColumn(String labelColuna, String nomeColuna, int size, int tipoCelula) {
        if (this.colunas == null) {
            this.colunas = new Vector();
        }
        BBCollumnModel collumn = new BBCollumnModel();
        collumn.setLabelColuna(labelColuna);
        collumn.setNomeColuna(nomeColuna);
        collumn.setTamanho(size);
        collumn.setTipoCelula(tipoCelula);
        this.colunas.add(collumn);
    }

    public void addColumn(String labelColuna, String nomeColuna) {
        this.addColumn(labelColuna, nomeColuna, 10);
    }

    public Class getColumnClass(int col) {
        Vector v = (Vector)this.dataVector.elementAt(0);
        if (v.elementAt(col) == null) {
            return new String().getClass();
        }
        return v.elementAt(col).getClass();
    }

    public BigDecimal getValorColuna(int coluna) {
        double soma = 0.0;
        int i = 0;
        while (i < this.getTabela().getRowCount()) {
            soma += Double.parseDouble(this.getTabela().getValueAt(i, coluna).toString());
            ++i;
        }
        return new BigDecimal(soma);
    }

    public boolean isCellEditable(int row, int col) {
        Class columnClass = this.getColumnClass(col);
        return columnClass != ImageIcon.class && columnClass != Date.class && columnClass != String.class;
    }

    public JTable getTabela() {
        return this.tabela;
    }

    public void setTabela(JTable table) throws Exception {
        this.tabela = table;
        this.atualizaTabela();
        this.limpaLabel(table);
    }

    private void limpaLabel(JTable table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumnModel().getColumn(i);
            col.setHeaderValue("  " + col.getHeaderValue().toString().trim());
            col.setHeaderRenderer(new DefaultTableCellRenderer());
            TableCellRenderer renderer = col.getHeaderRenderer();
            col.setHeaderRenderer(new TableHdrRenderer(renderer));
            ++i;
        }
    }

    public void refresh() {
        try {
            this.atualizaTabela();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void atualizaTabela() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.linhas = new Object[this.colecao.size()][this.colunas.size()];
        this.nomeColunas = new String[this.colunas.size()];
        if (this.colecao != null && this.colecao.size() > 0) {
            Iterator it = this.colecao.iterator();
            int nrLinha = 0;
            while (it.hasNext()) {
                Object object = it.next();
                int i = 0;
                while (i < this.colunas.size()) {
                    BBCollumnModel collumn = (BBCollumnModel)this.colunas.get(i);
                    if (collumn.getTipoCelula() == 0 || collumn.getTipoCelula() == 7) {
                        this.linhas[nrLinha][i] = BeanUtils.getProperty(object, collumn.getNomeColuna());
                    } else if (collumn.getTipoCelula() == 1) {
                        this.linhas[nrLinha][i] = this.formatarCPFCGC(BeanUtils.getProperty(object, collumn.getNomeColuna()));
                    } else if (collumn.getTipoCelula() == 2) {
                        this.linhas[nrLinha][i] = this.formataData(BeanUtils.getProperty(object, collumn.getNomeColuna()));
                    } else if (collumn.getTipoCelula() == 3) {
                        this.linhas[nrLinha][i] = new Boolean(false);
                    } else if (collumn.getTipoCelula() == 4) {
                        this.linhas[nrLinha][i] = this.formataDecimal(BeanUtils.getProperty(object, collumn.getNomeColuna()));
                    } else if (collumn.getTipoCelula() == 5) {
                        this.linhas[nrLinha][i] = this.formatarCPFCGCOUTROS(BeanUtils.getProperty(object, collumn.getNomeColuna()));
                    } else if (collumn.getTipoCelula() == 6) {
                        String vr = BeanUtils.getProperty(object, collumn.getNomeColuna());
                        this.linhas[nrLinha][i] = vr.trim().equals("1") ? new ImageIcon(this.getClass().getResource("/icones/ok.gif")) : new ImageIcon(this.getClass().getResource("/icones/blank.gif"));
                    } else if (collumn.getTipoCelula() == 8) {
                        this.linhas[nrLinha][i] = this.getNossoNumero(BeanUtils.getProperty(object, collumn.getNomeColuna()));
                    }
                    this.nomeColunas[i] = collumn.getLabelColuna();
                    ++i;
                }
                ++nrLinha;
            }
        } else {
            int i = 0;
            while (i < this.colunas.size()) {
                BBCollumnModel collumn = (BBCollumnModel)this.colunas.get(i);
                this.nomeColunas[i] = collumn.getLabelColuna();
                ++i;
            }
        }
        this.setDataVector(this.linhas, this.nomeColunas);
        this.tabela.setModel(this);
        int i = 0;
        while (i < this.colunas.size()) {
            this.alinhaColuna();
            BBCollumnModel collumn = (BBCollumnModel)this.colunas.get(i);
            this.tabela.getColumnModel().getColumn(i).setPreferredWidth(collumn.getTamanho());
            this.tabela.getColumnModel().getColumn(i).setWidth(collumn.getTamanho());
            this.tabela.getColumnModel().getColumn(i).setMinWidth(collumn.getTamanho());
            switch (collumn.getTipoCelula()) {
                case 2: {
                    this.alinharColunasTabela(i, 0);
                    break;
                }
                case 4: {
                    this.alinharColunasTabela(i, 2);
                    break;
                }
                case 7: {
                    this.alinharColunasTabela(i, 0);
                }
            }
            ++i;
        }
        this.tabela.validate();
        this.tabela.repaint();
        this.tabela.getTableHeader().addMouseListener(this);
        this.tabela.setFocusable(true);
        JTableHeader tableHeader = this.getTabela().getTableHeader();
        tableHeader.setFont(new Font("Dialog", 1, 12));
        int columnCount = tableHeader.getColumnModel().getColumnCount();
        this.ordem = new int[columnCount];
        int i2 = 0;
        while (i2 < columnCount) {
            this.ordem[i2] = 1;
            ++i2;
        }
    }

    private void alinhaColuna() {
        final TableCellRenderer defRenderer = this.getTabela().getTableHeader().getDefaultRenderer();
        this.getTabela().getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = defRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)c;
                    dtcr.setHorizontalAlignment(0);
                    dtcr.setBorder(new CompoundBorder(dtcr.getBorder(), new EmptyBorder(0, 0, 0, 0)));
                }
                return c;
            }
        });
    }

    public Collection getCollection() {
        return this.colecao;
    }

    public void SetCollection(Collection colecao) throws Exception {
        this.colecao = colecao;
        this.atualizaTabela();
    }

    public Set getHashSet() {
        HashSet hashColecao = new HashSet();
        hashColecao.addAll(this.colecao);
        return hashColecao;
    }

    public void adicionaObjeto(Object obj) {
        Object[] objs = new Object[this.colunas.size()];
        int i = 0;
        while (i < this.colunas.size()) {
            BBCollumnModel collumn = (BBCollumnModel)this.colunas.get(i);
            try {
                objs[i] = BeanUtils.getProperty(obj, collumn.getNomeColuna());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.colecao.add(obj);
        try {
            this.atualizaTabela();
        }
        catch (IllegalAccessException e) {
            UtilLog.getLog().debug(e);
        }
        catch (InvocationTargetException e) {
            UtilLog.getLog().debug(e);
        }
        catch (NoSuchMethodException e) {
            UtilLog.getLog().debug(e);
        }
    }

    public void excluiObjetoSelecionado() {
        this.excluiObjeto(this.getObjetoSelecionado());
    }

    public void excluiObjeto(Object obj) {
        this.colecao.remove(obj);
        try {
            this.atualizaTabela();
        }
        catch (IllegalAccessException e) {
            UtilLog.getLog().debug(e);
        }
        catch (InvocationTargetException e) {
            UtilLog.getLog().debug(e);
        }
        catch (NoSuchMethodException e) {
            UtilLog.getLog().debug(e);
        }
    }

    public Object getObjetoSelecionado() {
        ArrayList list = new ArrayList();
        list.addAll(this.colecao);
        return list.get(this.tabela.getSelectedRow());
    }

    public Object getObjeto(int linha) {
        ArrayList list = new ArrayList();
        list.addAll(this.colecao);
        return list.get(linha);
    }

    public ArrayList getRegistrosSelecionados() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getValueAt(i, 0).equals(new Boolean(true))) {
                list.add(this.getObjeto(i));
            }
            ++i;
        }
        return list;
    }

    public void limpaTabela() {
        this.colecao.removeAll(this.colecao);
        try {
            this.atualizaTabela();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private String formatarCPFCGC(String value) {
        if (value == null || value.length() < 1) {
            return "";
        }
        if ((value = value.trim()).length() <= 11) {
            boolean valCPF = false;
            StringBuffer sb = new StringBuffer(14);
            try {
                sb.append(value);
                while (sb.length() < 11) {
                    sb.insert(0, '0');
                }
                valCPF = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!valCPF) {
                while (sb.length() <= 14) {
                    sb.insert(0, '0');
                }
                return this.formatarCPFCGC(sb.toString());
            }
            return FormatadorNumero.formatarCPF(sb.toString().trim());
        }
        if (value.length() <= 14) {
            return FormatadorNumero.formatarCGC(value.trim());
        }
        String texto = value;
        texto.substring(texto.length() - 14, texto.length());
        return this.formatarCPFCGC(texto);
    }

    private String formatarCPFCGCOUTROS(String value) {
        if (value == null || value.length() < 1) {
            return "";
        }
        if ((value = value.trim()).length() == 11) {
            StringBuffer sb = new StringBuffer(14);
            sb.append(value);
            return FormatadorNumero.formatarCPF(sb.toString().trim());
        }
        if (value.length() == 14) {
            return FormatadorNumero.formatarCGC(value.trim());
        }
        return value;
    }

    private String formataData(String data) {
        if (data == null || data.trim().equals("")) {
            return "";
        }
        String ano = data.substring(0, 4);
        String mes = data.substring(5, 7);
        String dia = data.substring(8, 10);
        return String.valueOf(dia) + "/" + mes + "/" + ano;
    }

    private String formataDecimal(String valor) {
        if (valor.indexOf("%") > 0) {
            valor = valor.substring(0, valor.indexOf("%"));
        }
        if (valor == null || valor.trim().equals("")) {
            return "0,00";
        }
        DecimalFormat df = new DecimalFormat("###,##0.00");
        double db = Double.parseDouble(valor);
        return df.format(db);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.getTabela().getTableHeader() && this.isSorted()) {
            this.sortColumn(e);
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void sortColumn(int nroCol) {
        int i;
        int columnCount;
        Vector<Vector> linhas = this.getDataVector();
        if (linhas.size() == 0) {
            return;
        }
        this.limpaLabel(this.tabela);
        Vector anterior = (Vector)this.getDataVector().clone();
        JTableHeader tableHeader = this.getTabela().getTableHeader();
        final int colIndex = nroCol;
        TableColumn col = tableHeader.getColumnModel().getColumn(colIndex);
        col.setHeaderRenderer(new DefaultTableCellRenderer());
        TableCellRenderer renderer = col.getHeaderRenderer();
        boolean asc = this.ordem[colIndex] == 1;
        col.setHeaderRenderer(new TableHdrRenderer(renderer, asc));
        if (this.ordem[colIndex] == 1) {
            Collections.sort(linhas, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Vector v1 = (Vector)o1;
                    Vector v2 = (Vector)o2;
                    Object i1 = (Comparable)v1.get(colIndex);
                    Object i2 = (Comparable)v2.get(colIndex);
                    if (i1 == null) {
                        i1 = "";
                    } else if (i2 == null) {
                        i2 = "";
                    }
                    return i1.compareTo(i2);
                }
            });
            columnCount = tableHeader.getColumnModel().getColumnCount();
            i = 0;
            while (i < columnCount) {
                if (i == colIndex) {
                    this.ordem[colIndex] = -1;
                } else {
                    this.ordem[i] = 1;
                }
                ++i;
            }
        } else {
            Collections.sort(linhas, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Vector v1 = (Vector)o1;
                    Vector v2 = (Vector)o2;
                    Object i1 = (Comparable)v1.get(colIndex);
                    Object i2 = (Comparable)v2.get(colIndex);
                    if (i1 == null) {
                        i1 = "";
                    } else if (i2 == null) {
                        i2 = "";
                    }
                    return i1.compareTo(i2) * -1;
                }
            });
            columnCount = tableHeader.getColumnModel().getColumnCount();
            i = 0;
            while (i < columnCount) {
                if (i == colIndex) {
                    this.ordem[colIndex] = 1;
                } else {
                    this.ordem[i] = -1;
                }
                ++i;
            }
        }
        ArrayList listAnterior = new ArrayList();
        listAnterior.addAll(this.colecao);
        ArrayList listNova = new ArrayList();
        int i2 = 0;
        while (i2 < linhas.size()) {
            int j = 0;
            while (j < anterior.size()) {
                if (((Object)linhas.get(i2)).equals(anterior.get(j))) {
                    listNova.add(listAnterior.get(j));
                    break;
                }
                ++j;
            }
            ++i2;
        }
        this.colecao.removeAll(this.colecao);
        this.colecao.addAll(listNova);
        this.getTabela().repaint();
    }

    private void sortColumn(MouseEvent evt) {
        int i;
        int columnCount;
        Vector<Vector> linhas = this.getDataVector();
        if (linhas.size() == 0) {
            return;
        }
        this.limpaLabel(this.tabela);
        Vector anterior = (Vector)this.getDataVector().clone();
        JTableHeader tableHeader = this.getTabela().getTableHeader();
        Point point = new Point(evt.getX(), evt.getY());
        final int colIndex = tableHeader.columnAtPoint(point);
        TableColumn col = tableHeader.getColumnModel().getColumn(colIndex);
        col.setHeaderRenderer(new DefaultTableCellRenderer());
        TableCellRenderer renderer = col.getHeaderRenderer();
        boolean asc = this.ordem[colIndex] == 1;
        col.setHeaderRenderer(new TableHdrRenderer(renderer, asc));
        if (this.ordem[colIndex] == 1) {
            Collections.sort(linhas, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Vector v1 = (Vector)o1;
                    Vector v2 = (Vector)o2;
                    Object i1 = (Comparable)v1.get(colIndex);
                    Object i2 = (Comparable)v2.get(colIndex);
                    if (i1 == null) {
                        i1 = "";
                    } else if (i2 == null) {
                        i2 = "";
                    }
                    return i1.compareTo(i2);
                }
            });
            columnCount = tableHeader.getColumnModel().getColumnCount();
            i = 0;
            while (i < columnCount) {
                if (i == colIndex) {
                    this.ordem[colIndex] = -1;
                } else {
                    this.ordem[i] = 1;
                }
                ++i;
            }
        } else {
            Collections.sort(linhas, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Vector v1 = (Vector)o1;
                    Vector v2 = (Vector)o2;
                    Object i1 = (Comparable)v1.get(colIndex);
                    Object i2 = (Comparable)v2.get(colIndex);
                    if (i1 == null) {
                        i1 = "";
                    } else if (i2 == null) {
                        i2 = "";
                    }
                    return i1.compareTo(i2) * -1;
                }
            });
            columnCount = tableHeader.getColumnModel().getColumnCount();
            i = 0;
            while (i < columnCount) {
                if (i == colIndex) {
                    this.ordem[colIndex] = 1;
                } else {
                    this.ordem[i] = -1;
                }
                ++i;
            }
        }
        ArrayList listAnterior = new ArrayList();
        listAnterior.addAll(this.colecao);
        ArrayList listNova = new ArrayList();
        int i2 = 0;
        while (i2 < linhas.size()) {
            int j = 0;
            while (j < anterior.size()) {
                if (((Object)linhas.get(i2)).equals(anterior.get(j))) {
                    listNova.add(listAnterior.get(j));
                    break;
                }
                ++j;
            }
            ++i2;
        }
        this.colecao.removeAll(this.colecao);
        this.colecao.addAll(listNova);
        this.getTabela().repaint();
    }

    private void alinharColunasTabela(int posicaoColuna, int tipoAlinhamento) {
        DefaultTableCellRenderer alinhamento = new DefaultTableCellRenderer();
        switch (tipoAlinhamento) {
            case 0: {
                alinhamento.setHorizontalAlignment(0);
                break;
            }
            case 1: {
                alinhamento.setHorizontalAlignment(2);
                break;
            }
            case 2: {
                alinhamento.setHorizontalAlignment(4);
            }
        }
        TableColumn tc = this.tabela.getColumnModel().getColumn(posicaoColuna);
        tc.setCellRenderer(alinhamento);
    }

    private String getNossoNumero(Object str) {
        if (str == null) {
            return "";
        }
        long l = -1L;
        try {
            l = Long.parseLong(str.toString().trim());
        }
        catch (Exception e) {
            return str.toString().trim();
        }
        if (l == 0L) {
            return "GERADO PELO BB";
        }
        return str.toString().trim();
    }

    public Vector getColunas() {
        return this.colunas;
    }
}

