/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;

class ButtonEditor
extends DefaultCellEditor {
    protected JButton button = new JButton();
    private String label;
    private boolean isPushed;

    public ButtonEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        return this.button;
    }

    public Object getCellEditorValue() {
        if (this.isPushed) {
            JOptionPane.showMessageDialog(this.button, String.valueOf(this.label) + ": Ouch!");
            System.out.println(String.valueOf(this.label) + ": Ouch!");
        }
        this.isPushed = false;
        return new String(this.label);
    }

    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

