/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.dominio.action.ConsultarListaConvenenteAction;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxConvenente
extends BBJComboBox {
    ConvenenteTO convenenteTO;

    public void carregar() {
        this.convenenteTO = null;
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaConvenenteAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaConvenente());
        if (dominioForm.getListaConvenente().size() == 1) {
            Iterator<ConvenenteTO> iterator = dominioForm.getListaConvenente().iterator();
            while (iterator.hasNext()) {
                ConvenenteTO convenente;
                this.convenenteTO = convenente = iterator.next();
            }
        }
    }

    private void preencherCombo(Collection<ConvenenteTO> listaConvenente) {
        Collections.sort((ArrayList)listaConvenente, new Comparator<ConvenenteTO>(){

            @Override
            public int compare(ConvenenteTO o1, ConvenenteTO o2) {
                return o1.getPessoaTO().getTextoNome().compareTo(o2.getPessoaTO().getTextoNome());
            }
        });
        this.setModel(this.getDefaultComboBoxModel(listaConvenente));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<ConvenenteTO> listaConvenente) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaConvenente);
        this.inserirElementoVazio(defaultComboBoxModel);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<ConvenenteTO> listaConvenente) {
        return new DefaultComboBoxModel<Object>(listaConvenente.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(null);
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt(null, 0);
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    private ConsultarListaConvenenteAction getConsultarListaConvenenteAction() {
        return this.getActionFactory().novoConsultarListaConvenenteAction();
    }

    public ConvenenteTO getConvenenteTO() {
        return this.convenenteTO;
    }
}

