/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ConsultarPessoaComboForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJText;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboPopup;

public class BBJComboBoxEditavel
extends JPanel
implements IAcao,
ItemListener,
FocusListener {
    private JComboBox comboBox = null;
    private int maxChars = 50;
    private static final Dimension PREFERREDSIZE = new Dimension(0, 20);
    private boolean editavel = false;
    private MyComboBoxEditor comboBoxEditor = null;
    private ActionListener actionListener = null;
    private BBJText textField;

    public BBJComboBoxEditavel(int maxChars, boolean editavel) {
        this.setLayout(new BorderLayout());
        this.editavel = editavel;
        this.maxChars = maxChars;
        this.setPreferredSize(PREFERREDSIZE);
        this.add((Component)this.getComboBox(), "Center");
    }

    public JComboBox getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
            this.comboBox.setEditable(this.isEditavel());
            this.comboBox.setEditor(this.getComboBoxEditor());
            this.comboBox.setMaximumRowCount(8);
            this.comboBox.setFont(BBJEstilos.TEXTOEDITAVEL.getFont());
            this.comboBox.setForeground(BBJEstilos.TEXTOEDITAVEL.getColor());
            this.comboBox.setBackground(BBJEstilos.TEXTOEDITAVEL.getBackcolor());
            this.comboBox.setMinimumSize(PREFERREDSIZE);
            this.comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.comboBox.addItemListener(this);
        }
        return this.comboBox;
    }

    public MyComboBoxEditor getComboBoxEditor() {
        if (this.comboBoxEditor == null) {
            this.comboBoxEditor = new MyComboBoxEditor(this.getMaxChars());
        }
        return this.comboBoxEditor;
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("Combo Box Example");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new BBJComboBoxEditavel(20, true));
        frame.pack();
        frame.setVisible(true);
    }

    public void requestFocus() {
        this.getTextField().requestFocus();
    }

    public void setToolTipText(String text) {
        this.getTextField().setToolTipText(text);
        this.getComboBox().setToolTipText(text);
    }

    public void setEnabled(boolean enabled) {
        this.getComboBox().setEnabled(enabled);
        this.getTextField().setEnabled(enabled);
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public PluginActionAbstrato getAcao() {
        return this.getTextField().getAcao();
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.getTextField().setAcao(acao);
    }

    public boolean isEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public void setSelectedItem(Object obj) {
        this.getComboBox().setSelectedItem(obj);
    }

    public void setModel(DefaultComboBoxModel defaultComboBoxModel) {
        this.getComboBox().setModel(defaultComboBoxModel);
    }

    public void removeAllItems() {
        this.getComboBox().removeAllItems();
    }

    public void addItem(Object item) {
        this.getComboBox().addItem(item);
    }

    public Object getSelectedItem() {
        return this.getComboBox().getSelectedItem();
    }

    public void setPopupVisible(boolean popupVisivel) {
        this.getComboBox().setPopupVisible(popupVisivel);
    }

    public void setItem(String texto) {
        this.getTextField().setText(texto);
    }

    public String getItem() {
        return this.getTextField().getText();
    }

    public int getItemCount() {
        return this.getComboBox().getItemCount();
    }

    public int getSelectedIndex() {
        return this.getComboBox().getSelectedIndex();
    }

    public Object getItemAt(int index) {
        return this.getComboBox().getItemAt(index);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public ComboBoxModel getModel() {
        return this.getComboBox().getModel();
    }

    private void processarAcao() {
        ConsultarPessoaComboForm form = new ConsultarPessoaComboForm();
        form.setNomePessoa(this.getTextField().getText());
        PluginActionAbstrato action = this.getAction(this.getTextField());
        try {
            action.executar(form);
            Collection lista = form.getColecaoRegistros();
            this.getComboBox().setModel(this.getDefaultComboBoxModel(lista));
            if (lista.size() != 0) {
                this.getComboBox().setPopupVisible(true);
            }
        }
        catch (BBException e) {
            e.printStackTrace();
        }
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection lista) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(lista);
        this.inserirElementoVazio(defaultComboBoxModel);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection lista) {
        return new DefaultComboBoxModel<Object>(lista.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(null);
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt(null, 0);
    }

    protected PluginActionAbstrato getAction(Component componente) {
        IAcao acaoComponente = (IAcao)((Object)componente);
        return acaoComponente.getAcao();
    }

    public BBJText getTextField() {
        if (this.textField == null) {
            this.textField = new BBJText();
            this.textField.setTipoEntrada(2);
            this.textField.addFocusListener(this);
            this.textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String actionComand = e.getActionCommand();
                    if (actionComand != null && actionComand.trim().length() > 0) {
                        int keyCode = UtilConversorDeInteger.converterParaPrimitivo(actionComand);
                        switch (keyCode) {
                            case 32: {
                                BBJComboBoxEditavel.this.processarAcao();
                                break;
                            }
                            case 40: {
                                break;
                            }
                            case 38: {
                                break;
                            }
                            case 10: {
                                BBJComboBoxEditavel.this.posicionarComboBox();
                                BBJComboBoxEditavel.this.getComboBox().hidePopup();
                            }
                        }
                    }
                }
            });
            this.textField.setMaxChar(this.maxChars);
            this.textField.setFocusTraversalKeysEnabled(true);
        }
        return this.textField;
    }

    protected void posicionarComboBox() {
        BasicComboPopup popup = (BasicComboPopup)this.comboBox.getUI().getAccessibleChild(this, 0);
        int selectedIndex = popup.getList().getSelectedIndex();
        this.getComboBox().setSelectedIndex(selectedIndex);
        ActionEvent event = new ActionEvent(this.getComboBox(), 1, "SELECTED");
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ActionEvent event = new ActionEvent(evt.getSource(), 1, "SELECTED");
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(event);
            }
        } else if (evt.getStateChange() == 2) {
            ActionEvent event = new ActionEvent(evt.getSource(), 1, "DESELECTED");
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(event);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        this.getComboBox().removeAllItems();
    }

    public void focusLost(FocusEvent e) {
        this.getComboBox().removeAllItems();
        this.setPopupVisible(false);
    }

    class MyComboBoxEditor
    implements ComboBoxEditor {
        private EditorPanel panel;

        public MyComboBoxEditor(int maxChars) {
            this.panel = new EditorPanel(maxChars);
        }

        public void setItem(Object anObject) {
            if (anObject != null) {
                this.panel.setText(anObject.toString());
            }
        }

        public Component getEditorComponent() {
            return this.panel;
        }

        public Object getItem() {
            return this.panel.getText();
        }

        public void selectAll() {
            this.panel.selectAll();
        }

        public void addActionListener(ActionListener l) {
        }

        public void removeActionListener(ActionListener l) {
        }

        private class EditorPanel
        extends JPanel {
            public EditorPanel(int maxChars) {
                this.setLayout(new BorderLayout());
                this.add((Component)BBJComboBoxEditavel.this.getTextField(), "North");
            }

            public void setText(String s) {
                BBJComboBoxEditavel.this.textField.setText(s);
            }

            public String getText() {
                return BBJComboBoxEditavel.this.textField.getText();
            }

            public void selectAll() {
                BBJComboBoxEditavel.this.textField.selectAll();
            }
        }
    }
}

