/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.dominio.action.ConsultarListaGrupoUsuarioAction;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.factory.ActionFactory;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxGrupoUsuario
extends BBJComboBox {
    private String hint = "";

    public BBJComboBoxGrupoUsuario() {
        this.carregar();
    }

    public void carregar() {
        DominioForm dominioForm = this.getDominioForm();
        ConsultarListaGrupoUsuarioAction acao = ActionFactory.getInstancia().novoConsultarListaGrupoUsuarioAction();
        acao.executar(dominioForm);
        this.preencherCombo(dominioForm.getColecaoGrupoUsuario());
    }

    private void preencherCombo(Collection<GrupoUsuarioTO> colecao) {
        Collections.sort((ArrayList)colecao, new Comparator<GrupoUsuarioTO>(){

            @Override
            public int compare(GrupoUsuarioTO o1, GrupoUsuarioTO o2) {
                return o1.getTextoDescricao().compareTo(o2.getTextoDescricao());
            }
        });
        this.setModel(this.getDefaultComboboxModel(colecao));
    }

    private DefaultComboBoxModel getDefaultComboboxModel(Collection<GrupoUsuarioTO> colecao) {
        ArrayList<GrupoUsuarioTO> colecaoGrupos = new ArrayList<GrupoUsuarioTO>();
        GrupoUsuarioTO grupoUsuarioTO = this.getTOFactory().novoGrupoUsuarioTO();
        grupoUsuarioTO.setNomeGrupoUsuario("Selecione");
        grupoUsuarioTO.setNumeroIdentificadorGrupoUsuario(0);
        colecaoGrupos.add(grupoUsuarioTO);
        colecaoGrupos.addAll(colecao);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(colecaoGrupos.toArray());
        return model;
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    public TOFactory getTOFactory() {
        return TOFactory.getInstancia();
    }

    public void setHint(String text) {
        this.hint = text;
        super.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        super.setToolTipText(b ? this.hint : "");
    }
}

