/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.comboBox.BBJComboBoxEditavel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxLabelEditavel<T>
extends JPanel
implements IAcao {
    private String titulo;
    private int posicaoLabel = 0;
    private int larguralabel;
    private int largura;
    private BBJLabel jlTitulo;
    private BBJComboBoxEditavel combobox;
    private Map<String, T> opcoesCombo;
    private int maxChars = 50;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilolabel;
    private boolean isEditavel;
    private PluginActionAbstrato acao;
    private String toolTip = "";

    public BBJComboBoxLabelEditavel(String titulo, int posicaoLabel, Map<String, T> opcoesCombo) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.initialize();
    }

    public BBJComboBoxLabelEditavel(String titulo, boolean editavel, int posicaoLabel, int largura, int larguralabel) {
        this.titulo = titulo;
        this.isEditavel = editavel;
        this.posicaoLabel = posicaoLabel;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public void preencherCombo(Collection<T> lista) {
        this.getJcbCombo().setModel(this.getDefaultComboBoxModel(lista));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<T> lista) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(lista);
        this.inserirElementoVazio(defaultComboBoxModel);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<T> lista) {
        return new DefaultComboBoxModel<Object>(lista.toArray());
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt(null, 0);
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(null);
    }

    public BBJComboBoxLabelEditavel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.isEditavel = isEditavel;
        this.initialize();
    }

    public BBJComboBoxLabelEditavel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int larguralabel) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.isEditavel = isEditavel;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJComboBoxLabelEditavel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int largura, int larguralabel) {
        this(titulo, isEditavel, posicaoLabel, opcoesCombo, largura, larguralabel, 50);
    }

    public BBJComboBoxLabelEditavel(String titulo, boolean isEditavel, int posicaoLabel, Map<String, T> opcoesCombo, int largura, int larguralabel, int maxChars) {
        this.titulo = titulo;
        this.isEditavel = isEditavel;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCombo = opcoesCombo;
        this.largura = largura;
        this.larguralabel = larguralabel;
        this.maxChars = maxChars;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        this.setJComboBox(new BBJComboBoxEditavel(this.maxChars, this.isEditavel));
        this.getComboBox().setOpaque(false);
        this.getComboBox().setFont(this.estilotexto.getFont());
        this.getComboBox().setForeground(this.estilotexto.getColor());
        this.getComboBox().setBackground(this.estilotexto.getBackcolor());
        BBJLabel jlTitulo = new BBJLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.largura > 0) {
            Dimension dimfld = new Dimension(this.largura, 19);
            this.getComboBox().setPreferredSize(dimfld);
            this.getComboBox().setSize(dimfld);
        }
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.getComboBox());
        if (this.opcoesCombo != null) {
            this.loadCombo(this.opcoesCombo);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            int posiy = (int)this.getSize().getHeight() - (this.getComboBox().getHeight() + 5);
            g.drawString(this.titulo, 2, posiy);
        }
    }

    public void loadCombo(Map<String, T> opcoesCombo) {
        Iterator<T> itr = opcoesCombo.values().iterator();
        this.opcoesCombo = opcoesCombo;
        this.getJcbCombo().removeAllItems();
        while (itr.hasNext()) {
            T item = itr.next();
            this.getJcbCombo().addItem(item);
        }
        this.getJcbCombo().updateUI();
    }

    public void loadCombo(Collection<T> opcoes) {
        this.getJcbCombo().removeAllItems();
        for (T item : opcoes) {
            this.getJcbCombo().addItem(item);
        }
        this.getJcbCombo().updateUI();
    }

    public T getSelectedItem() {
        if (this.getJcbCombo() != null) {
            return (T)this.getJcbCombo().getSelectedItem();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getJcbCombo().setEnabled(enabled);
        this.getComboBox().setToolTipText(enabled ? this.toolTip : null);
    }

    public void setSelectedItem(T obj) {
        this.getComboBox().setSelectedItem(obj);
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        if (this.posicaoLabel == 0) {
            this.jlTitulo.setText(this.titulo);
        }
        this.repaint();
    }

    public Map<String, T> getOpcoesCombo() {
        return this.opcoesCombo;
    }

    public void setOpcoesCombo(Map<String, T> opcoesCombo) {
        this.opcoesCombo = opcoesCombo;
    }

    public BBJComboBoxEditavel getJcbCombo() {
        return this.getComboBox();
    }

    public BBJLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(BBJLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }

    public boolean isEditavel() {
        return this.isEditavel;
    }

    public void setEditavel(boolean isEditavel) {
        this.getComboBox().setBackground(isEditavel ? this.estilotexto.getBackcolor() : BBJEstilos.TEXTONAOEDITAVEL.getBackcolor());
        this.isEditavel = isEditavel;
    }

    @Override
    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.getJcbCombo().setAcao(acao);
        this.acao = acao;
    }

    @Override
    public void setName(String name) {
        this.getJcbCombo().setName(name);
    }

    public void setPopupVisible(boolean b) {
        this.getJcbCombo().setPopupVisible(true);
    }

    public void setTexto(String texto) {
        this.getJcbCombo().setItem(texto);
    }

    private void setJComboBox(BBJComboBoxEditavel jcbCombo) {
        this.combobox = jcbCombo;
    }

    public BBJComboBoxEditavel getComboBox() {
        return this.combobox;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        if (maxChars < 0) {
            maxChars = 0;
        }
        this.getComboBox().setMaxChars(maxChars);
        this.maxChars = maxChars;
    }

    @Override
    public void requestFocus() {
        this.getComboBox().requestFocus();
    }

    public void limparCombos() {
        this.getComboBox().removeAllItems();
    }

    public int getItemCount() {
        return this.getComboBox().getItemCount();
    }

    public int getSelectedIndex() {
        return this.getComboBox().getSelectedIndex();
    }

    public Object getItemAt(int index) {
        return this.getComboBox().getItemAt(index);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.toolTip = text;
        if (this.jlTitulo != null) {
            this.jlTitulo.setToolTipText(text);
        }
        if (this.combobox != null) {
            this.combobox.setToolTipText(text);
        }
    }
}

